<?php

/**
 * 驾照等级 技巧教学等级
 */

namespace Game\Data\PVE;

use Framework\Log\LogMark;
use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;

class DrivingLicenseData
{
    use PlayerDBHandler;

    public int $playerId;

    public const DrivingLicenseLv = "DrivingLicenseLv"; //已获得驾照最高等级
    public const TeachingSkillLv = "TeachingSkillLv";   //技巧教学等级

    public const DB_KEY_MAP = array(
        self::DrivingLicenseLv => "drivingLicenseLv",
        self::TeachingSkillLv => "teachingSkillLv",
    );

    public int $drivingLicenseLv = 0;
    public int $teachingSkillLv = 0;

    public function __construct($playerId)
    {
        $this->playerId = $playerId;
    }

    public function searchDB(): bool
    {
        $result = array();
        if (!$this->searchTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            $result)
        ) {
            return false;
        }
        if (empty($result)) {
            return false;
        }
        foreach ($result as $k => $v) {
            $this->setDBData($k, $v);
        }
        return true;
    }

    public function updateDB(): bool
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            $data[$k] = $this->$v;
        }
        return $this->updateTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            $data
        );
    }
    private function setDBData($key, $value)
    {
        if (!array_key_exists($key, self::DB_KEY_MAP)) {
            return;
        }
        $property = self::DB_KEY_MAP[$key];
        $this->$property = (int)$value;
    }
}
