<?php

/**
 * 生涯关卡
 */

namespace Game\Data\PVE;

use Framework\DB\Handler\PlayerDBHandler;
use Framework\DB\Handler\PlayerDBPipe;
use Game\Constant\DBTableDefine;

class CareerLevelData
{
    use PlayerDBHandler;

    public int $playerId;

    public const LevelId = "LevelId";   //关卡id
    public const Status = "Status"; //关卡状态
    public const StarNum = "StarNum";   //获得星数
    public const BestTime = "BestTime"; //最佳时间
    public const Target1Status = "Target1Status";   //目标完成状态
    public const Target2Status = "Target2Status";
    public const Target3Status = "Target3Status";

    public const DB_KEY_MAP = array(
        self::LevelId => "levelId",
        self::Status => "status",
        self::StarNum => "starNum",
        self::BestTime => "bestTime",
        self::Target1Status => "target1Status",
        self::Target2Status => "target2Status",
        self::Target3Status => "target3Status",
    );

    public int $levelId;
    public int $status;
    public int $starNum;
    public int $bestTime;
    public int $target1Status;
    public int $target2Status;
    public int $target3Status;

    //关卡状态
    public const STATUS_LEVEL_UNLOCKING = 1;  //关卡状态 解锁
    public const STATUS_LEVEL_FINISH = 2;  //关卡状态 完成
    public const STATUS_LEVEL_DISABLE = 3; //关卡状态 停止使用 支线

    //目标状态
    public const STATUS_TARGET_DISABLE = -1;  //目标状态 不使用当前条件
    public const STATUS_TARGET_UNLOCKING = 0;  //目标状态 解锁
    public const STATUS_TARGET_UNFINISHED = 1;  //目标状态 未完成
    public const STATUS_TARGET_REWARD = 2;  //目标状态 完成并领取奖励

    public function __construct($playerId)
    {
        $this->playerId = $playerId;
        $this->levelId = 0;
    }

    public function initLevel(int $levelId)
    {
        $this->levelId = $levelId;
        $this->status = self::STATUS_LEVEL_UNLOCKING;
        $this->starNum = 0;
        $this->bestTime = 0;
        $this->target1Status = self::STATUS_TARGET_UNLOCKING;
        $this->target2Status = self::STATUS_TARGET_UNLOCKING;
        $this->target3Status = self::STATUS_TARGET_UNLOCKING;
    }

    public function searchDB(int $levelId): bool
    {
        $result = array();
        if (!$this->searchTitle(
                DBTableDefine::TABLE_CAREER_LEVEL,
                $this->playerId,
                $levelId,
                $result
            )
        ) {
            return false;
        }
        $this->formatData($result);
        return true;
    }

    public function saveDB(): bool
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            $data[$k] = $this->$v;
        }
        return $this->updateTitle(
            DBTableDefine::TABLE_CAREER_LEVEL,
            $this->playerId,
            $this->levelId,
            $data,
        );
    }

    public function registerDB(): bool
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            $data[$k] = $this->$v;
        }
        return PlayerDBPipe::getInstance()->createTitle(
            DBTableDefine::TABLE_CAREER_LEVEL,
            $this->playerId,
            $this->levelId,
            $data
        );
    }

    private function formatData(array $result)
    {
        foreach ($result as $key => $value) {
            $val = self::DB_KEY_MAP[$key] ?? $key;
            $this->$val = (int)$value;
        }
    }
}
