<?php
/**
 * 在线通知
 * @date 2022-4-16
 * @author JZW
 **/

namespace Game\Data;

use Framework\DB\Handler\PlayerDBHandler;
use Framework\Lib\Utils;
use Framework\Logic\OnLineLogic;
use Framework\Logic\TemplateHelp;
use Game\Constant\DBTableDefine;

class NoticeData
{
    use PlayerDBHandler;
    use TemplateHelp;
    use OnLineLogic;

    //消息通知类型
    public const Notice_Index_Apply_Friend = 0; //好友申请
    public const Notice_Index_Invited_Game = 1; //好友邀请游戏
    public const Notice_Index_Tips = 2;  //心跳通知的提示文本信息

    //存DB的消息类型
    public const saveDBIndex = array(
        self::Notice_Index_Invited_Game,
    );

    public int $dbTitle = 0;  //表title
    public int $playerId;  //发送Id
    public int $otherPlayerId;  //接收Id

    //Notice来源定义
    public const Source_Friend_Pop = 1;    // 好友申请弹窗
    public const Source_Friend_List = 2;   // 好友申请列表
    public const Source_Friend_Game = 3;   // 好友游戏邀请

    //不发送消息的来源
    public const Source_End = array(
        self::Source_Friend_List,
    );

    public const Tips_Refuse_Invited_Game_Language_Id = 100019;  //对方拒绝了您的邀请
    public const Tips_Refuse_Add_Friends_Language_Id = 100030;  //对方已拒绝了您的好友申请
    public const Tips_Add_Friends_Language_Id = 100031;         //对方已接受了您的好友申请
    public const Tips_Other_Friend_Over_Max = 100024;           //对方好友列表已满

    public function addNotice(): bool
    {
        if (in_array($this->dbTitle, self::saveDBIndex)) {
            return $this->updateTitle(
                DBTableDefine::TABLE_NOTICE,
                $this->otherPlayerId,
                $this->dbTitle,
                [
                    $this->playerId => Utils::getServerTimestamp(),
                ]
            );
        }
        return true;
    }

    public function delNotice(): bool
    {
        if (in_array($this->dbTitle, self::saveDBIndex)) {
            return $this->delTermMulti(
                $ret,
                DBTableDefine::TABLE_NOTICE,
                $this->playerId,
                $this->dbTitle,
                [
                    $this->otherPlayerId
                ]
            );
        }
        return true;
    }

    //清理Notice
    //每次登录的时候,做一次清理操作
    public function clearNotice(): bool
    {
        if (in_array($this->dbTitle, self::saveDBIndex)) {
            return $this->deleteTable(DBTableDefine::TABLE_NOTICE, $this->playerId, $this->dbTitle);
        }
        return true;
    }

    //获取消息数量
    public function getNoticeNum(): int
    {
        $this->searchTermLen(
            DBTableDefine::TABLE_NOTICE,
            $this->playerId,
            $this->dbTitle,
            $len);
        return (int)$len;
    }
}