<?php

/**
 * MoneyData.php
 * 文件描述
 * Created On 2022/1/24
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Game\Data;

use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;
use Game\Model\MoneyModel;

class MoneyData
{
    use PlayerDBHandler;

    public const GOLD = "Gold";       // 金币
    public const TICKETS = "Tickets"; // 点券
    public const DIAMOND = "Diamond"; // 钻石
    public const CLUB = "Club";       // 俱乐部代币
    public const SEASON = "Season";   // 赛季代币
    public const ZL = "WarToken";   // 战令代币

    public const DB_KEY_MAP = array(
        self::GOLD => "gold",
        self::TICKETS => "tickets",
        self::DIAMOND => "diamond",
        self::CLUB => "club",
        self::SEASON => "season",
        self::ZL => "warToken",
    );

    public int $gold = 0;
    public int $tickets = 0;
    public int $diamond = 0;
    public int $club = 0;
    public int $season = 0;
    public int $warToken = 0;
    public int $id;
    public int $playerId;

    public function __construct($playerId)
    {
        $this->playerId = $playerId;
    }

    public function getMoney($moneyType): int
    {
        switch ($moneyType) {
            case MoneyModel::TYPE_GOLD:
                return $this->gold;
            case MoneyModel::TYPE_TICKETS:
                return $this->tickets;
            case MoneyModel::TYPE_DIAMOND:
                return $this->diamond;
            case  MoneyModel::TYPE_CLUB:
                return $this->club;
            case  MoneyModel::TYPE_SEASON:
                return $this->season;
            case  MoneyModel::TYPE_ZL:
                return $this->warToken;
        }
        return 0;
    }

    public function addMoney($moneyType, $val)
    {
        switch ($moneyType) {
            case MoneyModel::TYPE_GOLD:
                $this->gold += $val;
                break;
            case MoneyModel::TYPE_TICKETS:
                $this->tickets += $val;
                break;
            case MoneyModel::TYPE_DIAMOND:
                $this->diamond += $val;
                break;
            case MoneyModel::TYPE_CLUB:
                $this->club += $val;
                break;
            case MoneyModel::TYPE_SEASON:
                $this->season += $val;
                break;
            case MoneyModel::TYPE_ZL:
                $this->warToken += $val;
        }
    }

    public function resetMoney($moneyType)
    {
        switch ($moneyType) {
            case MoneyModel::TYPE_GOLD:
                $this->gold = 0;
                break;
            case MoneyModel::TYPE_TICKETS:
                $this->tickets = 0;
                break;
            case MoneyModel::TYPE_DIAMOND:
                $this->diamond = 0;
                break;
            case MoneyModel::TYPE_CLUB:
                $this->club = 0;
                break;
            case MoneyModel::TYPE_SEASON:
                $this->season = 0;
                break;
            case MoneyModel::TYPE_ZL:
                $this->warToken = 0;
        }
    }

    public function subMoney($moneyType, $val)
    {
        switch ($moneyType) {
            case MoneyModel::TYPE_GOLD:
                $this->gold -= $val;
                break;
            case MoneyModel::TYPE_TICKETS:
                $this->tickets -= $val;
                break;
            case MoneyModel::TYPE_DIAMOND:
                $this->diamond -= $val;
                break;
            case MoneyModel::TYPE_CLUB:
                $this->club -= $val;
                break;
            case MoneyModel::TYPE_SEASON:
                $this->season -= $val;
                break;
            case MoneyModel::TYPE_ZL:
                $this->warToken -= $val;
                break;
        }
    }

    public function loadFromDB($id): bool
    {
        $this->id = $id;
        $result = array();
        if (
            !$this->searchTitle(
                DBTableDefine::TABLE_ACCOUNT,
                $this->playerId,
                $this->id,
                $result
            )
        ) {
            return false;
        }
        foreach ($result as $k => $v) {
            $this->setDBData($k, $v);
        }
        return true;
    }

    public function setDBData($key, $val)
    {
        if (!array_key_exists($key, self::DB_KEY_MAP)) {
            return;
        }

        $property = self::DB_KEY_MAP[$key];
        $this->$property = (int)$val;
    }

    private function getDBData(): array
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            $data[$k] = $this->$v;
        }
        return $data;
    }

    public function createDB($score)
    {
        $data = $this->getDBData();
        $this->createTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            $this->id,
            $data,
            $score
        );
    }

    public function updateDB(): bool
    {
        $data = $this->getDBData();
        return $this->updateTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            $this->id,
            $data
        );
    }
}
