<?php
/**
 * 比赛后点赞
 * @date 2022/6/14/014
 * @author JZW
 **/

namespace Game\Data\Likes;

use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\ClientErrorCode;
use Game\Constant\DBTableDefine;
use Game\Data\RoleExtData;

class RankData
{
    use PlayerDBHandler;

    public const INDEX = 1; //点赞
    public int $playerId;
    public int $otherId;
    public int $matchId;
    public int $errorCode = 0;

    public function addLikes(): bool
    {
        $res = $this->getLikes();
        if (array_key_exists($this->playerId, $res)){
            $this->errorCode = ClientErrorCode::ERROR_RANK_LIKES_EXISTS_ERROR;
            return false;
        }
        $res[$this->playerId] = 1;
        $data[$this->matchId] = json_encode($res);
        if (!$this->updateTitle(DBTableDefine::TABLE_LIKES, $this->otherId, self::INDEX, $data)){
            $this->errorCode = ClientErrorCode::ERROR_ADD_RANK_LIKES_ERROR;
            return false;
        }
        return true;
    }

    public function getLikes(): array
    {
        if (!$this->searchTermMulti($data, DBTableDefine::TABLE_LIKES, $this->otherId, self::INDEX, [$this->matchId])){
            return [];
        }
        if ($data[$this->matchId] == false){
            return [];
        }
        return json_decode($data[$this->matchId], true);
    }
}