<?php
/**
 * 好友最近游戏
 * @date 2022-4-21
 * @author JZW
 **/


namespace Game\Data\Friends;


use Game\Constant\DBTableDefine;

class FriendsLastGameData extends Friend
{
    public int $DB_INDEX = 5; //最近游戏记录
    public int $gameId;
    public int $gameType;
    public int $mapId;
    public int $time;
    public string $ext = "";
    public array $delList =[];

    public const DB_GameType = "GameType";
    public const DB_MapId = "MapId";
    public const DB_Time = "Time";
    public const DB_Ext = "Ext";

    public const DB_KEY_MAP = array(
        self::DB_GameType => "gameType",
        self::DB_MapId => "mapId",
        self::DB_Time => 'time',
        self::DB_Ext => "ext",
    );


    public function Init():bool
    {
        $param = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            $param[$k] = $this->$v;
        }

        $data[$this->gameId] = json_encode($param);

        return $this->updateTitle(DBTableDefine::TABLE_FRIENDS,
            $this->playerId, $this->DB_INDEX,
            $data,
        );
    }

    public function getGameData(&$ret): bool
    {
        if(!$this->searchTermMulti($ret,DBTableDefine::TABLE_FRIENDS,
            $this->playerId,
            $this->DB_INDEX,
            [$this->gameId],
            )
        ) {
            return false;
        }
        if ($ret[$this->gameId] === false){
            return false;
        }
        $ret = json_decode($ret[$this->gameId], true);
        return true;
    }

    public function updateDB(): bool
    {
        return $this->updateTitle(DBTableDefine::TABLE_FRIENDS,
            $this->playerId, $this->DB_INDEX,[
                $this->gameId => $this->ext,
            ]);
    }

    public function getDBIndex():array
    {
        if (!$this->searchTitle(DBTableDefine::TABLE_FRIENDS,
            $this->playerId, $this->DB_INDEX,$ret)){
            return [];
        }
        return $ret;
    }

    public function deleteDB(&$ret): bool
    {
        return $this->delTermMulti($ret,
            DBTableDefine::TABLE_FRIENDS,
            $this->playerId,
            $this->DB_INDEX,
            $this->delList
        );
    }

}