<?php
/**
 * 好友系统数据
 * @date 2022-3-21
 * @author JZW
 **/


namespace Game\Data\Friends;


use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Game\Constant\DBTableDefine;

class FriendsData extends Friend
{

    public int $DB_INDEX = 0; //好友表
    public const DB_TIME = "createTime";
    public const DB_REMARK = "remark";   //备注
    public const INTIMACY = "intimacy"; //亲密度
    public const INTIMACY_ICON = "intimacyIcon";    //亲密度徽章(小火苗)
    public const MATCH_NUM = "matchNum";    //比赛次数
    public const KEEP_FIRE = "keepFire";     //保持火苗
    public const CD_TIME = "cdTime";    //解除关系冷静期
    public const INTIMACY_CREATE_TIME = "intimacyCreateTime";   //亲密关系建立时间
    public const INTIMACY_ID = "intimacyId";    //亲密关系

    public const femaleMaxScore = 63;  //女性最大 值=0
    public const maleMaxScore = 127;   //男性最大 值=1

    //搜索 查询等好友信息
    public const IS_BLACK = "IsBlack";  //是否在黑名单
    public const IS_FRIEND = "IsFriend";  //是否好友

    public string $remark = "";
    public int $createTime = 0;
    public int $intimacy = 0;   //亲密度
    public int $intimacyIcon = 0;   //亲密度徽章(小火苗)
    public int $matchNum = 0;
    public bool $keepFire = false;
    public int $cdTime = 0;
    public int $intimacyCreateTime = 0;
    public int $intimacyId = 0;

    public const DB_MAP = array(
        self::DB_TIME => "createTime",
        self::DB_REMARK => "remark",
        self::INTIMACY => "intimacy",
        self::INTIMACY_ICON => "intimacyIcon",
        self::MATCH_NUM => "matchNum",
        self::KEEP_FIRE => "keepFire",
        self::CD_TIME => "cdTime",
        self::INTIMACY_CREATE_TIME => "intimacyCreateTime",
        self::INTIMACY_ID => "intimacyId",
    );

    //创建数据
    public function saveDB(): bool
    {
        $data = array(
            self::DB_TIME => Utils::getServerTimestamp(),
            self::DB_REMARK => $this->remark,
            self::INTIMACY => 0,
            self::INTIMACY_ICON => 0,
            self::MATCH_NUM => 0,
            self::KEEP_FIRE => false ,
            self::CD_TIME => 0,
            self::INTIMACY_CREATE_TIME => 0,
            self::INTIMACY_ID => 0,
        );

        return $this->updateTitle(
            DBTableDefine::TABLE_FRIENDS,
            $this->playerId,
            $this->DB_INDEX,
            [
                $this->respondentPlayerId => json_encode($data),
            ]
        );
    }

    public function updateDB(): bool
    {
        $data = $this->getData();
        return $this->updateTitle(
            DBTableDefine::TABLE_FRIENDS,
            $this->playerId,
            $this->DB_INDEX,
            [
                $this->respondentPlayerId => json_encode($data)
            ]
        );
    }

    public function getData(): array
    {
        $ret = [];
        foreach (self::DB_MAP as $key => $str) {
            $ret[$key] = $this->$str;
        }
        return $ret;
    }

    public function formateData(array $result)
    {
        LogMark::getInstance()->markInfo(
            "[FriendData] formatData",
            $result
        );
        foreach ($result as $key => $value) {
            if (array_key_exists($key, self::DB_MAP)) {
                $this->$key = $value;
            }
        }
    }
}