<?php

/**
 * 好友亲密度周记录,跨周删除
 */

namespace Game\Data\Friends;

use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;

class FriendIntimacyMarkData
{
    use PlayerDBHandler;

    public int $playerId;
    public int $respondentPlayerId; //对方的playerId

    public function __construct(int $playerId, int $respondentPlayerId)
    {
        $this->playerId = $playerId;
        $this->respondentPlayerId = $respondentPlayerId;
    }

    //增加值
    public function addValue(int $index, int $addValue): bool
    {
        return $this->autoAddTerm(
            DBTableDefine::TABLE_FRIENDS,
            $this->playerId,
            $index,
            $this->respondentPlayerId,
            $addValue,
            $ret
        );
    }

    //查询值
    public function getValue(int $index): int
    {
        $this->searchTerm(
            $ret,
            DBTableDefine::TABLE_FRIENDS,
            $this->playerId,
            $index,
            $this->respondentPlayerId
        );
        //没有 ret=""
        return (int)$ret;
    }

    //删除表
    public function clearTable(int $index): bool
    {
        return $this->deleteTable(
            DBTableDefine::TABLE_FRIENDS,
            $this->playerId,
            $index
        );
    }

    //删除字段
    public function delValue(int $index)
    {
        $ret = 0;
        return $this->delTermMulti(
            $ret,
            DBTableDefine::TABLE_FRIENDS,
            $this->playerId,
            $index,
            array(
                $this->respondentPlayerId
            )
        );
    }
}
