<?php

/**
 * 好友亲密关系
 */

namespace Game\Data\Friends;

use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;

class FriendIntimacyData
{
    use PlayerDBHandler;

    public int $playerId;
    public int $respondentPlayerId; //对方的playerId

    public const INDEX_INTIMACY = 8;    //好友亲密关系

    public function __construct(int $playerId, int $respondentPlayerId)
    {
        $this->playerId = $playerId;
        $this->respondentPlayerId = $respondentPlayerId;
    }

    //设置关系
    public function setIntimacyId(int $intimacyId): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_FRIENDS,
            $this->playerId,
            self::INDEX_INTIMACY,
            array(
                $this->respondentPlayerId => $intimacyId,
            )
        );
    }

    //查询对应关系
    public function getIntimacyId(): int
    {
        $this->searchTerm(
            $ret,
            DBTableDefine::TABLE_FRIENDS,
            $this->playerId,
            self::INDEX_INTIMACY,
            $this->respondentPlayerId
        );
        //没有 ret="" 为0
        return (int)$ret;
    }

    //删除关系
    public function delIntimacyId()
    {
        $ret = 0;
        return $this->delTermMulti(
            $ret,
            DBTableDefine::TABLE_FRIENDS,
            $this->playerId,
            self::INDEX_INTIMACY,
            array(
                $this->respondentPlayerId
            )
        );
    }

    //查询关系数量
    public function getIntimacyNum(): int
    {
        $this->searchTermLen(
            DBTableDefine::TABLE_FRIENDS,
            $this->playerId,
            self::INDEX_INTIMACY,
            $result
        );
        return (int)$result;
    }

    //获取全部好友关系
    public function getAllIntimacy(): array
    {
        $this->searchTitle(
            DBTableDefine::TABLE_FRIENDS,
            $this->playerId,
            self::INDEX_INTIMACY,
            $result
        );
        return $result;
    }
}
