<?php

/**
 * 好友亲密关系申请记录
 */

namespace Game\Data\Friends;

use Framework\DB\Handler\PlayerDBHandler;
use Framework\Lib\Utils;
use Game\Constant\DBTableDefine;

class FriendIntimacyApplyData
{
    use PlayerDBHandler;

    public const APPLY_ID = "ApplyId";      //申请Id
    public const APPLY_PLAYER_ID = "ApplyPlayerId"; //申请人Id
    public const TARGET_PLAYER_ID = "TargetPlayerId";   //对方Id
    public const CREATE_TIME = "CreateTime";        //创建时间
    public const INTIMACY_ID = "IntimacyId";    //关系id

    public int $applyId;
    public int $applyPlayerId;
    public int $targetPlayerId;
    public int $createTime;
    public int $intimacyId;

    public const DB_KEY_MAP = array(
        self::APPLY_ID => "applyId",
        self::APPLY_PLAYER_ID => "applyPlayerId",
        self::TARGET_PLAYER_ID => "targetPlayerId",
        self::CREATE_TIME => "createTime",
        self::INTIMACY_ID => "intimacyId",
    );

    public const INDEX_INTIMACY_APPLY = 9;    //好友亲密关系申请

    public function setApplyId(int $applyId)
    {
        $this->applyId = $applyId;
    }

    public function setApplyPlayerId(int $applyPlayerId)
    {
        $this->applyPlayerId = $applyPlayerId;
    }

    public function setTargetPlayerId(int $targetPlayerId)
    {
        $this->targetPlayerId = $targetPlayerId;
    }

    public function setCreateTime()
    {
        $this->createTime = Utils::getServerTimestamp();
    }

    public function setIntimacyId(int $intimacyId)
    {
        $this->intimacyId = $intimacyId;
    }

    //创建申请
    public function createApply(): bool
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $key => $value) {
            $data[$key] = $this->$value;
        }
        //索引
        $b1 = $this->addPlayerRank(
            DBTableDefine::TABLE_FRIEND_INTIMACY_APPLY_INDEX,
            0,
            0,
            $this->applyId,
            $this->createTime
        );
        //数据
        $b2 = $this->updateTitle(
            DBTableDefine::TABLE_FRIEND_INTIMACY_APPLY,
            0,
            $this->applyId,
            $data,
        );
        //申请信息
        $b3 = $this->updateTitle(
            DBTableDefine::TABLE_FRIENDS,
            $this->targetPlayerId,
            self::INDEX_INTIMACY_APPLY,
            array(
                $this->applyPlayerId => $this->applyId,
            )
        );
        return $b1 && $b2 && $b3;
    }

    //查询数据
    public function getApplyData(int $applyId): array
    {
        $result = array();
        if (!$this->searchTitle(
            DBTableDefine::TABLE_FRIEND_INTIMACY_APPLY,
            0,
            $applyId,
            $result)
        ) {
            return array();
        }
        return $result;
    }

    public function getMyApply(): array
    {
        $result = array();
        if (!$this->searchTitle(
            DBTableDefine::TABLE_FRIENDS,
            $this->targetPlayerId,
            self::INDEX_INTIMACY_APPLY,
            $result)
        ) {
            return array();
        }
        return $result;
    }

    //查询是否有申请信息
    public function getApplyId(): int
    {
        $this->searchTerm(
            $ret,
            DBTableDefine::TABLE_FRIENDS,
            $this->applyPlayerId,
            self::INDEX_INTIMACY_APPLY,
            $this->targetPlayerId
        );
        //没有 ret="" 为0
        return (int)$ret;
    }

    //查询过期申请
    public function searchExpireApply(int $time): array
    {
        $arr = array();
        if (false == $this->searchRank(
            DBTableDefine::TABLE_FRIEND_INTIMACY_APPLY_INDEX,
            0,
            0,
            $time,
            $arr))
        {
            return array();
        }
        return $arr;
    }

    //删除过期申请
    public function delApply(int $applyId): bool
    {
        //删除索引
        $b1 = $this->delRank(
            DBTableDefine::TABLE_FRIEND_INTIMACY_APPLY_INDEX,
            0,
            $applyId
        );
        //删除数据
        $b2 = $this->deleteTable(
            DBTableDefine::TABLE_FRIEND_INTIMACY_APPLY,
            0,
            $applyId
        );
        //删除申请
        $b3 = $this->delTermMulti(
            $ret,
            DBTableDefine::TABLE_FRIENDS,
            $this->targetPlayerId,
            self::INDEX_INTIMACY_APPLY,
            array(
                $this->applyPlayerId,
            )
        );
        return $b1 && $b2 && $b3;
    }

    //删除索引
    public function delApplyIndex(int $applyId): bool
    {
        //删除索引
        return $this->delRank(
            DBTableDefine::TABLE_FRIEND_INTIMACY_APPLY_INDEX,
            0,
            $applyId
        );
    }
}
