<?php
/**
 * Friend类的父类
 * @date 2022-3-30
 * @author JZW
 **/
namespace Game\Data\Friends;

use Framework\DB\Handler\PlayerDBHandler;
use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Game\Constant\DBTableDefine;

 class Friend
{
    use PlayerDBHandler;

     /**
      * @var int
      *     0:好友列表, FriendsData
      *     1:好友申请表, FriendsRequestData
      *     2:好友黑名单, FriendsBlackData
      *     3:好友点赞表, FriendsGoodData    //合并到排行榜点赞
      *     4:陌生人黑名单 StrangerBlackData
      *     5:最近游戏记录 FriendsLastGameData
      *     6:亲密度上限记录:组队,点赞记录 FriendIntimacyMarkData
      *     7:亲密度上限记录:送礼 FriendIntimacyMarkData
      *     8:好友亲密关系 FriendIntimacyData
      *     9:亲密关系申请记录 FriendIntimacyApplyData
      */
    public int $DB_INDEX = 0;

    public const SortTypeSearch = 1;  //搜索排序
    public const SortTypeLastInFirstOut = 2;  //后进先拍
    public const SortTypeNot = 3;  //不排序

    public const SourceMineList = 0;  //我的好友列表查询-来源
    public const SourceApplyList = 1; //申请列表查询-来源
    public const SourceBlackList = 2; //黑名单列表查询-来源
    public const SourceSearch = 3; //搜索-来源
    public const SourceUpMark = 4; //更新-来源
    public const SourceSendStatus = 5; //更新好友状态-来源

    public int $playerId; //申请人的playerId
    public int $respondentPlayerId; //被申请人的playerId


    public function saveDB(): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_FRIENDS,
            $this->playerId,
            $this->DB_INDEX,
            [
                $this->respondentPlayerId => Utils::getServerTimestamp(),
            ]
        );
    }

     public function getOneFriend(&$result): bool
     {
         if (!$this->searchTermMulti(
             $result,
             DBTableDefine::TABLE_FRIENDS,
             $this->playerId,
             $this->DB_INDEX,
             [
                 $this->respondentPlayerId
             ]
         )){
             return false;
         }
         if (isset($result[$this->respondentPlayerId])) {
             if (is_numeric($result[$this->respondentPlayerId])) {
                 //黑名单
                 $result = $result[$this->respondentPlayerId];
             } else {
                 //好友信息
                 $result = json_decode($result[$this->respondentPlayerId], true);
             }
         } else {
             $result = "";
         }
         return true;
     }

    public function getList(&$result): bool
    {
        return $this->searchTitle(
            DBTableDefine::TABLE_FRIENDS,
            $this->playerId,
            $this->DB_INDEX,
            $result);
    }

    public function deleteDB(&$ret): bool
    {
        return $this->delTermMulti(
            $ret,
            DBTableDefine::TABLE_FRIENDS,
            $this->playerId,
            $this->DB_INDEX,
            [
                $this->respondentPlayerId
            ]);
    }
}