<?php

/**
 * 好友亲密度任务进度
 */

namespace Game\Data;

use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;

class FriendIntimacyRewardData
{
    use PlayerDBHandler;

    public int $playerId;

    public const FriendIntimacyRewardOpen = "FriendIntimacyRewardOpen"; //满足条件的人数
    public const FriendIntimacyRewardScore = "FriendIntimacyRewardScore";   //积分
    public const FriendIntimacyRewardSchedule = "FriendIntimacyRewardSchedule"; //领取奖励进度,[]

    public const DB_KEY_MAP = array(
        self::FriendIntimacyRewardOpen => "friendIntimacyRewardOpen",
        self::FriendIntimacyRewardScore => "friendIntimacyRewardScore",
        self::FriendIntimacyRewardSchedule => "friendIntimacyRewardSchedule",
    );

    public const OPEN = 1;
    public const CLOSE = 0;

    public int $friendIntimacyRewardOpen = self::CLOSE;
    public int $friendIntimacyRewardScore = 0;
    public string $friendIntimacyRewardSchedule;

    public function __construct(int $playerId)
    {
        $this->playerId = $playerId;
    }

    public function openFriendIntimacyReward()
    {
        $this->friendIntimacyRewardOpen = self::OPEN;   //开启活动 人数为1
        $this->friendIntimacyRewardScore = 0;
        $this->friendIntimacyRewardSchedule = "[]";
        $this->updateDB();
    }

    public function closeFriendIntimacyReward()
    {
        $this->friendIntimacyRewardOpen = self::CLOSE;
        $this->friendIntimacyRewardScore = 0;
        $this->friendIntimacyRewardSchedule = "[]";
        $this->updateDB();
    }

    public function resetFriendIntimacyReward()
    {
        $this->friendIntimacyRewardScore = 0;
        $this->friendIntimacyRewardSchedule = "[]";
        $this->updateDB();
    }

    //更新开启人数
    public function updateFrinedIntimacyNum(bool $add) {
        if ($add) {
            $this->friendIntimacyRewardOpen++;
        } else {
            $this->friendIntimacyRewardOpen--;
            if ($this->friendIntimacyRewardOpen < 0) {
                $this->friendIntimacyRewardOpen = self::CLOSE;
            }
        }
        $this->updateDB();
    }

    public function searchDB(): bool
    {
        $result = array();
        if (!$this->searchTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            $result)
        ) {
            return false;
        }
        if (empty($result)) {
            return false;
        }
        foreach ($result as $k => $v) {
            $this->setDBData($k, $v);
        }
        return true;
    }

    public function updateDB(): bool
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            $data[$k] = $this->$v;
        }
        return $this->updateTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            $data
        );
    }

    private function setDBData($key, $value)
    {
        if (!array_key_exists($key, self::DB_KEY_MAP)) {
            return;
        }
        $property = self::DB_KEY_MAP[$key];
        if (is_numeric($value)) {
            $this->$property = (int)$value;
        } else {
            $this->$property = $value;
        }
    }
}
