<?php
/**
 * 汇总条件
 * @date 2022/6/20
 * @author JZW
 **/

namespace Game\Data;


use Framework\Log\LogMark;
use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\ClientErrorCode;
use Game\Constant\DBTableDefine;

class EventConditionData
{
    use PlayerDBHandler;

    public int $playerId = 0;

    //特殊key前缀
    public const EVENT_CONDITION_KEY_RANK = "Rank";
    public const EVENT_CONDITION_KEY_CAR_EXTERIOR_REFIT = "CarExtRefit";   //车外观改造
    public const EVENT_CONDITION_KEY_CAR_REFIT = "CarRefit";   //车改造(系统强化)
    public const EVENT_CONDITION_KEY_ONLINE_TIME = "OnlineTime";    //在线时间

    public function __construct(int $playerId)
    {
        $this->playerId = $playerId;
    }

    public function searchDB(array $keyList): array
    {
        $result = array();
        if (!$this->searchTermMulti(
            $result,
            DBTableDefine::TABLE_EVENT_POOLED,
            $this->playerId,
            0,
            $keyList)
        ){
            LogMark::getInstance()->markError(
                ClientErrorCode::ERROR_EVENT_QUERY_FAIL,
                "[EventConditionData] searchDB query Error",
                $keyList);

            return array();
        }
        return $result;
    }

    public function increaseEventConditionDataValue(string $key, int $value, &$ret): bool
    {
        if (!$this->autoAddTerm(
            DBTableDefine::TABLE_EVENT_POOLED,
            $this->playerId,
            0,
            $key,
            $value,
            $ret)
        ){
            LogMark::getInstance()->markError(
                ClientErrorCode::ERROR_EVENT_ADD_FAIL,
                "[EventConditionData] increaseEventConditionDataValue fail",
                array(
                    "key" => $key,
                    "value" => $value
                )
            );
            return false;
        }
        return true;
    }

    public function resetEventConditionDataValue(string $key): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_EVENT_POOLED,
            $this->playerId,
            0,
            [
                $key => 0
            ]
        );
    }

    public function delEventConditionDataKey(string $key):bool
    {
        if (!$this->delTermMulti(
            $ret,
            DBTableDefine::TABLE_EVENT_POOLED,
            $this->playerId,
            0,
            [$key])
        ){
            LogMark::getInstance()->markError(
                ClientErrorCode::ERROR_EVENT_ADD_FAIL,
                "[EventConditionData] del key Error",
                [
                    "key" => $key
                ]
            );
            return false;
        }
        return true;
    }
}