<?php
/**
 * 俱乐部全局数据类
 * namesearch single commonDBHandler
 */
namespace Game\Data\Club;

use Framework\Log\LogMark;
use Framework\DB\Handler\CommonDBHandler;
use Game\Constant\DBTableDefine;
use Game\Constant\GameErrorCode;

class CommCLubData {
    use CommonDBHandler;

    // 创建俱乐部名称查询（ZSet）
    public function createNameClubID(string $name, int $clubID): bool {
        if (false == $this->addFullServerSingleRank(DBTableDefine::TABLE_CLUB_NAME, 0, $name,$clubID)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_CREATE_ERROR,
                "[CommClubData] create club name -clubID error!",
                array(
                    "clubID" => $clubID,
                )
            );
            return false;
        }
        return true;
    }

    // 创建俱乐部id（set）
    public function createRandomClubID(int $clubID): bool {
        if (false == $this->setMemberFullServerSingle(DBTableDefine::TABLE_CLUB_SEARCH, 0, $clubID)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_CREATE_ERROR,
                "[CommClubData] create random ClubID error!",
                array(
                    "clubID" => $clubID,
                )
            );
            return false;
        }
        return true;
    }

    // 创建俱乐部,创建时间.活跃度表
    public function addTimeAndActiveClubId(int $clubId, int $clubCreateTime, int $active): bool
    {
        if (false == $this->addFullServerSingleRank(DBTableDefine::TABLE_CLUB_CREATE_TIME_AND_ACTIVE, 0, $clubId, $clubCreateTime.".".$active)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_CREATE_ERROR,
                "[CommClubData] create club create time and active error!",
                array(
                    "clubID" => $clubId,
                    "createTime" => $clubCreateTime,
                    "active" => $active,
                )
            );
            return false;
        }
        return true;
    }
    public function searchActiveClubId(int $clubId): int
    {
        $ret = '';
        if (false == $this->searchCommRankScoreByKey(DBTableDefine::TABLE_CLUB_CREATE_TIME_AND_ACTIVE, 0, $clubId, $ret)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                "[CommClubData] search ClubActive error!",
                array(
                    "clubId" => $clubId,
                )
            );
            return 0;
        }
        if(empty($ret)) {
            return 0;
        }
        $arrActive = explode(".", (double)$ret);
        return $arrActive[1] ?? 0;
    }
    // 搜索某个时间之后创建的活跃度最高的俱乐部
    public function searchCreatedLast($time)
    {
        if (false == $this->searchRevRankByIndexCommon(DBTableDefine::TABLE_CLUB_CREATE_TIME_AND_ACTIVE, 0, $time, "+inf", $ret)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                "[CommClubData] searchBestActive error!",
            );
            return false;
        }
        if (empty($ret)) {
            return [];
        }
        $result = [];
        foreach ($ret as $clubId => $scores) {
            $arr = explode(".", (int)$scores);
            if (!isset($arr[1])){
                continue;
            }
            $result[$clubId] = $arr[1];
        }
        if (count($result) > 0) {
            arsort($result, SORT_NUMERIC);
        }
        return $result;
    }

    // 检测俱乐部名称是否已经存在
    public function clubNameCheckData(string $clubName):bool {
        $ret = '';
        if (false == $this->searchCommRankScoreByKey(DBTableDefine::TABLE_CLUB_NAME, 0, $clubName, $ret)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                "[CommClubData] search clubName error!",
                array(
                    "clubName" => $clubName,
                )
            );
            return false;
        }
        if(empty($ret)) {
            return false;
        }
        return true;
    }

    // 通过俱乐部ID删除俱乐部名称表
    public function delClubNameByClubID(int $clubID): bool
    {
        if(!$this->delZRemByScore(DBTableDefine::TABLE_CLUB_NAME, 0, $clubID, $clubID)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_DELETE_ERROR,
                '[CommClubData] del search club name error!',
            );
            return false;
        }
        return true;
    }

    // 删除俱乐部随即表值
    public function delSearchClubMember(int $clubID): bool
    {
        if(!$this->delSetMember(DBTableDefine::TABLE_CLUB_SEARCH, 0, $clubID)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_DELETE_ERROR,
                '[CommClubData] del search club error!',
            );
            return false;
        }
        return true;
    }

    // 通过名称查询俱乐部id
    public function searchClubIDByCLubName($name):int {
        $ret = '';
        if (false == $this->searchCommRankScoreByKey(DBTableDefine::TABLE_CLUB_NAME, 0, $name, $ret)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                "[CommClubData] search clubName error!",
                array(
                    "clubName" => $name,
                )
            );
            return 0;
        }
        if(empty($ret)) {
            return 0;
        }
        return intval($ret);
    }
}