<?php
/**
 * 俱乐部商店
 * cluster playerHandler
 */
namespace Game\Data\Club;

use Framework\Log\LogMark;
use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;
use Game\Constant\GameErrorCode;

class ClubStoreData {
    use PlayerDBhandler;

    public const ID = "ID";
    public const Num = "Num";
    public const Time = "Time";

    public int    $playerID = 0;

    public function __construct(
        int $playerID
    ) {
        $this->playerID      = $playerID;
    }
    // 商品购买记录更新
    public function addBuyStoreRecord(int $storeID, int $num, int $seasonID):bool {
        if (!$this->addPlayerRank(DBTableDefine::TABLE_CLUB_STORE_RECORD, $this->playerID, $seasonID
            , $storeID, $num)){
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[ClubStoreData] add buy store record error!'
            );
            return false;
        }
        return true;
    }

    // 俱乐部商品购买记录查询   storeID - num
    public function searchStoreRecordByStoreID(int $storeID, int $seasonID):int {
        $res = 0;
        if (!$this->searchRankScoreByKey(DBTableDefine::TABLE_CLUB_STORE_RECORD, $this->playerID, $seasonID
            , $storeID, $res)){
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                '[ClubStoreData] search buy store record error!'
            );
            return 0;
        }
        if(empty($res)) {
            return 0;
        }
        return $res;
    }

    // 商品购买最后时间更新
    public function addBuyStoreLastTime(int $storeID, int $time, int $seasonID):bool {
        if (!$this->addPlayerRank(DBTableDefine::TABLE_CLUB_BUY_STORE_LAST_TIME, $this->playerID, $seasonID
            , $storeID, $time)){
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[ClubStoreData] add buy store last time error!'
            );
            return false;
        }
        return true;
    }

    // 俱乐部商品购买最后时间查询   storeID - time
    public function searchStoreLastTimeByStoreID(int $storeID, int $seasonID):int {
        $res = 0;
        if (!$this->searchRankScoreByKey(DBTableDefine::TABLE_CLUB_BUY_STORE_LAST_TIME, $this->playerID, $seasonID
            , $storeID, $res)){
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_SEARCH_ERROR,
                '[ClubStoreData] search buy store last time error!'
            );
            return 0;
        }
        if(empty($res)) {
            return 0;
        }
        return $res;
    }
}