<?php
/**
 * 俱乐部玩家数据类
 * cluster playerDBHandler
 */

namespace Game\Data\Club;

use Framework\Log\LogMark;
use Framework\DB\Handler\PlayerDBHandler;
use Framework\Lib\Utils;
use Game\Constant\DBTableDefine;
use Game\Constant\GameErrorCode;
use Game\Data\AccountData;

class ClubPlayerData
{
    use PlayerDBHandler;

    public const CLUB_ID = "ClubID";
    public const ServerID = "ServerID";
    public const POST = "Post";
    public const ACTIVE_TOTAL = "ActiveTotal";  //累计活跃点
    public const ACTIVE = "Active";   //每日活跃点
    public const ACTIVE_BATTLE_PASS = "ActiveBattlePass";   //battlePass活跃点
    public const CONTRIBUTE = "Contribute";
    public const JOIN_TIME = "JoinTime";
    public const ACTIVE_REFRESH = "ActiveRefresh";
    public const HONORARY_TITLE = "HonoraryTitle";
    public const USE_CARS = "UseCars";
    public const DJ_NAME = "DJName";
    public const CARS_REFRESH = "CarsRefresh"; //所有车辆重置时间
    public const BATTLE_PASS_REFRESH = "BattlePassRefresh";  //俱乐部战令刷新时间
    public const BATTLE_PASS_MONEY = "BattlePassMoney";  //俱乐部代币,由battlePass发放[已经领取]
    public const DAILY_DONATE_FLAG = "DailyDonateFlag";     //日常捐献完成标志 0未完成 1已完成

    public const CLUB_STATUS_DELETE = 0;  //删除状态
    public const CLUB_STATUS_ADD = 1;  //增加状态
    public const CLUB_STATUS_UPDATE = 2;  //更新状态

    public const DAILY_DONATE_STATUS_DOING = 0; //日常捐献完成状态 0未完成 1已完成
    public const DAILY_DONATE_STATUS_DONE = 1;

    public const DB_KEY_MAP = array(
        self::CLUB_ID => "clubID",
        self::ServerID => "serverID",
        self::POST => "post",
        self::ACTIVE => "active",
        self::CONTRIBUTE => "contribute",
        self::JOIN_TIME => "joinTime",
        self::ACTIVE_REFRESH => "activeRefresh",
        self::HONORARY_TITLE => "honorary",
        self::USE_CARS => "useCars",
        self::DJ_NAME => "djName",
        self::CARS_REFRESH => "carsRefresh",
        self::BATTLE_PASS_REFRESH => "battlePassRefresh",
        self::BATTLE_PASS_MONEY => "clubMoney",
        self::ACTIVE_BATTLE_PASS => "activeBattlePass",
        self::DAILY_DONATE_FLAG => "dailyDonateFlag",
    );

    public int $playerID;
    public int $serverID;      // 玩家所在区服id
    public int $clubID;
    public int $post;          // 职位 1：队员 2：管理员 3： 队长
    public int $active;        // 每日活跃值
    public int $activeBattlePass; //battlePass活跃值
    public int $activeTotal;  //总体活跃值
    public int $contribute;    // 贡献值
    public int $activeRefresh; // 前一次活跃度刷新时间
    public int $joinTime;
    public string $honorary;   // 比赛荣誉称号
    public string $useCars;       // 使用车辆 [carId => ["useTime"]]
    public string $djName;        // DJ 角色名称
    public int $carsRefresh;   // 车辆刷新时间
    public int $battlePassRefresh;   //战令刷新时间
    public int $clubMoney;  //battlePass活跃点转换的俱乐部代币[已领取]
    public int $dailyDonateFlag;

    public int $gender;  //性别
    public string $clot;  //服饰

    public function __construct(
        int $playerID, int $serverID, int $joinTime = 0, int $clubID = 0, int $post = 1, int $active = 0, int $contribute = 0, int $activeRefresh = 0, string $honorary = "", string $useCars = "", string $djName = "",
        int $carsRefresh = 0, int $battlePassRefresh = 0, int $clubMoney = 0, int $activeBattlePass = 0, int $activeTotal = 0
    )
    {
        $this->serverID = $serverID;
        $this->playerID = $playerID;
        $this->clubID = $clubID;
        $this->post = $post;
        $this->active = $active;
        $this->contribute = $contribute;
        $this->activeRefresh = $activeRefresh;
        $this->joinTime = $joinTime;
        $this->honorary = $honorary;
        $this->useCars = $useCars;
        $this->djName = $djName;
        $this->carsRefresh = $carsRefresh;
        $this->battlePassRefresh = $battlePassRefresh;
        $this->clubMoney = $clubMoney;
        $this->activeBattlePass = $activeBattlePass;
        $this->activeTotal = $activeTotal;
        $this->dailyDonateFlag = self::DAILY_DONATE_STATUS_DOING;
    }



    public function searchClubPlayer($playerID = 0): bool
    {
        if (!empty($playerID)) {
            $this->playerID = $playerID;
        }
        $clubItem = [];
        if (!$this->searchServerTitle(DBTableDefine::TABLE_CLUB_PLAYER, $this->playerID, 0, $this->serverID, $clubItem)) {
            return false;
        }
        if (empty($clubItem)) {
            return false;
        }

        $qAccount = $this->searchOtherServerAccount([AccountData::DB_GENDER, AccountData::DB_CLOTH_FEMALE, AccountData::DB_CLOTH_MALE], $this->playerID);
        if ($qAccount === false){
            return false;
        }

        $this->setPost((int)$clubItem[self::POST]);
        $this->setClubID((int)$clubItem[self::CLUB_ID]);
        $this->setActive((int)$clubItem[self::ACTIVE]);
        $this->setContribute((int)$clubItem[self::CONTRIBUTE]);
        $this->setActiveRefresh((int)$clubItem[self::ACTIVE_REFRESH]);
        $this->setBattlePassRefresh((int)$clubItem[self::BATTLE_PASS_REFRESH]);
        $this->setGender($qAccount[AccountData::DB_GENDER]);
        $this->setActiveBattlePass((int)$clubItem[self::ACTIVE_BATTLE_PASS]);
        $this->setDailyDonateFlag((int)$clubItem[self::DAILY_DONATE_FLAG]);
        if ($qAccount[AccountData::DB_GENDER] == AccountData::MALE){
            $this->setClot($qAccount[AccountData::DB_CLOTH_MALE]);
        }else{
            $this->setClot($qAccount[AccountData::DB_CLOTH_FEMALE]);
        }
        return true;
    }

    //查询其他服务器的Account数据
    public function searchOtherServerAccount($attr, $playerID = 0)
    {
        if (!empty($playerID)) {
            $this->playerID = $playerID;
        }

        if (!$this->searchServerTitle(DBTableDefine::TABLE_ACCOUNT, $this->playerID, 0, $this->serverID, $account)) {
            return false;
        }

        if (empty($account)) {
            return false;
        }
        if (is_string($attr)){
            if (!isset($account[$attr])){
                return false;
            }
            return $account[$attr];
        }
        $ret = [];
        if (is_array($attr)){
            foreach($attr as $str){
                if (!isset($account[$str])){
                    return false;
                }
                $ret[$str] = $account[$str];
            }
        }
        return $ret;
    }

    public function saveDB($playerID = 0): bool
    {
        if (!empty($playerID)) {
            $this->playerID = $playerID;
        }
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            $data[$k] = $this->$v;
        }

        if (!$this->updateServerTitle(DBTableDefine::TABLE_CLUB_PLAYER, $this->playerID, 0, $this->serverID, $data)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[ClubPlayerData] club player update error!', $data
            );
            return false;
        }
        return true;
    }

    public function deleteClubPlayer(): bool
    {
        if (!$this->deleteServerTitle(DBTableDefine::TABLE_CLUB_PLAYER, $this->playerID, 0, $this->serverID)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_DELETE_ERROR,
                '[ClubPlayerData] club player delete error!',
                ['playerID' => $this->playerID]
            );
            return false;
        }
        return true;
    }

    public function setPost(int $post)
    {
        $this->post = $post;
    }

    public function setClubID(int $clubID)
    {
        $this->clubID = $clubID;
    }

    public function setActive(int $active)
    {
        $this->active = $active;
    }

    public function setContribute(int $contribute)
    {
        $this->contribute = $contribute;
    }

    public function setActiveRefresh(int $activeRefresh)
    {
        $this->activeRefresh = $activeRefresh;
    }

    /**
     * @param string $honorary
     */
    public function setHonorary(string $honorary): void
    {
        $this->honorary = $honorary;
    }

    /**
     * @param string $useCars
     */
    public function setUseCars(string $useCars): void
    {
        $this->useCars = $useCars;
    }

    /**
     * @param string $djName
     */
    public function setDjName(string $djName): void
    {
        $this->djName = $djName;
    }

    /**
     * @param int $carsRefresh
     */
    public function setCarsRefresh(int $carsRefresh): void
    {
        $this->carsRefresh = $carsRefresh;
    }

    /**
     * @param int $joinTime
     */
    public function setJoinTime(int $joinTime): void
    {
        $this->joinTime = $joinTime;
    }

    /**
     * @param int $battlePassRefresh
     */
    public function setBattlePassRefresh(int $battlePassRefresh): void
    {
        $this->battlePassRefresh = $battlePassRefresh;
    }

    /**
     * @param int $activeBattlePass
     */
    public function setActiveBattlePass(int $activeBattlePass): void
    {
        $this->activeBattlePass = $activeBattlePass;
    }

    /**
     * @param int $activeTotal
     */
    public function setActiveTotal(int $activeTotal): void
    {
        $this->activeTotal = $activeTotal;
    }

    /**
     * @param int $clubMoney
     */
    public function setClubMoney(int $clubMoney): void
    {
        $this->clubMoney = $clubMoney;
    }

    /**
     * @param int $gender
     */
    public function setGender(int $gender): void
    {
        $this->gender = $gender;
    }

    /**
     * @param string $clot
     */
    public function setClot(string $clot): void
    {
        $this->clot = $clot;
    }

    public function setDailyDonateFlag(int $status): void
    {
        $this->dailyDonateFlag = $status;
    }

    //读取临时数据
    public function readTemporaryData(): array
    {
        if (!$this->searchQueue(DBTableDefine::TABLE_CLUB_SEARCH, $this->playerID, 0, -1, $search)) {
            return [];
        }
        return $search;
    }

    //存储临时数据
    public function storageTemporaryData($data): bool
    {
        if (!$this->deleteQueue(DBTableDefine::TABLE_CLUB_SEARCH, $this->playerID, -1, 0)) {
            return false;
        }
        foreach ($data as $clubId) {
            $this->addQueue(DBTableDefine::TABLE_CLUB_SEARCH, $this->playerID, $clubId);
        }
        return true;
    }

    //获取当日的活跃度值
    public function getActivity(): int
    {
        $key = strtotime("Ymd 00:00:00");
        if (!$this->searchTerm($time, DBTableDefine::TABLE_CLUB_PLAYER, $this->playerID, 0, $key)) {
            return 0;
        }
        return $time;
    }

    //更新每日活跃值
    public function upActivity($score): bool
    {
        $zeroTime = Utils::makeImmutableTime("now 00:00:00");
        if (!$this->autoAddTerm(DBTableDefine::TABLE_CLUB_PLAYER, $this->playerID, 0,$zeroTime, $score, $res)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[ClubPlayerData] club player update activity error!'
            );
            return false;
        }
        // 查
        $this->searchTerm($before, DBTableDefine::TABLE_CLUB_PLAYER, $this->playerID, 0, self::ACTIVE_REFRESH);
        if ($before < $zeroTime) {
            $this->updatePlayerDB([self::ACTIVE_REFRESH => $zeroTime]);
            $this->delAttribute([$before]);
        }
        return true;
    }
    //更新battlePass活跃值
    public function upBattlePassActive($score): bool
    {
        if (!$this->autoAddTerm(DBTableDefine::TABLE_CLUB_PLAYER, $this->playerID, 0,self::ACTIVE_BATTLE_PASS, $score, $res)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[ClubPlayerData] club player update activity error!'
            );
            return false;
        }
        return true;
    }
    //更新总活跃值
    public function upTotalActive($score): bool
    {
        if (!$this->autoAddTerm(DBTableDefine::TABLE_CLUB_PLAYER, $this->playerID, 0,self::ACTIVE_TOTAL, $score, $res)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[ClubPlayerData] club player update activity error!'
            );
            return false;
        }
        return  true;
    }
    //更新已领取的俱乐部代币
    public function upClubMoney($money): bool
    {
        if (!$this->autoAddTerm(DBTableDefine::TABLE_CLUB_PLAYER, $this->playerID, 0,self::BATTLE_PASS_MONEY, $money, $res)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[ClubPlayerData] club player update activity error!'
            );
            return false;
        }
        return  true;
    }

    //删除字段
    public function delAttribute(array $attr): bool
    {
        if ($this->delTermMulti($ret, DBTableDefine::TABLE_CLUB_PLAYER, $this->playerID, 0, $attr)) {
            return false;
        }
        return true;
    }


    //更新玩家的数据
    public function updatePlayerDB(array $attr): bool
    {
        if (!is_array($attr)) {
            return false;
        }
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            if (!isset($attr[$k])) {
                return false;
            }
            $data[$k] = $attr[$k];
        }

        if (!$this->updateServerTitle(DBTableDefine::TABLE_CLUB_PLAYER, $this->playerID, 0, $this->serverID, $data)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[ClubPlayerData] club player update error!', $data
            );
            return false;
        }
        return true;
    }
}