<?php
/**
 * 俱乐部战令
 * @date 2022/7/20/020
 * @author JZW
 **/

namespace Game\Data\Club;


use Framework\DB\Handler\PlayerDBHandler;
use Framework\Lib\Utils;
use Game\Config\GameConfig;
use Game\Constant\DBTableDefine;

class BattlePassData
{
    use PlayerDBHandler;

    public const MAX_LEVEL = 100;  //满级

    public const Index_Club = 1;  //俱乐部奖励

    public const Status_Reward = 1;  //领取奖励

    #俱乐部奖励类型
    public const TYPE_REWARD_ITEM = 1; //道具
    public const TYPE_REWARD_MONEY = 2; //货币
    public const TYPE_REWARD_EXP= 3; //数值

    public int $playerId;
    public int $rewardId;

    public function mondayIndex():int
    {
        return $refreshTime = Utils::makeImmutableTime("next Monday");
    }

    // 俱乐部奖励Id*1000  个人奖励Id不变
    public function saveDB($type):bool
    {
        $time = $this->mondayIndex();

        if ($type == self::Index_Club){
            $this->rewardId *= 1000;
        }
        if (!$this->updateTitle(DBTableDefine::TABLE_CLUB_BATTLE_PASS, $this->playerId, $time, [$this->rewardId => self::Status_Reward])){
            return false;
        }

        return (new ClubPlayerData($this->playerId, GameConfig::getInstance()->SERVER_ID()))->updatePlayerDB([ClubPlayerData::BATTLE_PASS_REFRESH => $time]);
    }

    // 删除过期的数据
    public function delDB($title): bool
    {
        return $this->deleteTitle(DBTableDefine::TABLE_CLUB_BATTLE_PASS, $this->playerId, $title);
    }

    // 获取当前的数据
    public function getData(): array
    {
        if (!$this->searchTitle(DBTableDefine::TABLE_CLUB_BATTLE_PASS, $this->playerId, $this->mondayIndex(), $data)){
            return [];
        }
        if ($data == ""){
            return [];
        }
        return $data;
    }

    // 检测battlePass满级后是否自动增加代币
    public function checkMaxLevel(): bool
    {
        if (!$this->searchTermLen(DBTableDefine::TABLE_CLUB_BATTLE_PASS, $this->playerId, $this->mondayIndex(), $length)){
            return false;
        }
        return $length > self::MAX_LEVEL;
    }

}