<?php

/**
 * CarExteriorRefit.php
 * 车辆外观改装
 */

namespace Game\Data;

use Framework\DB\Handler\PlayerDBHandler;
use Framework\Logic\TimerLogic;
use Game\Constant\DBTableDefine;
use Framework\Log\LogMark;
use Game\Constant\GameErrorCode;
use Framework\Logic\TemplateHelp;

class CarExteriorRefitData
{
    use PlayerDBHandler;
    use TimerLogic;
    use TemplateHelp;

    public const UID       = "UID";
    public const TPL_ID    = "TplID";
    public const CAR_ID    = "CarID";
    public const GET_TIME  = "GetTime";
    public const PARAMS    = "Params";

    public const DB_KEY_MAP = array(
        self::UID      => "uid",
        self::TPL_ID   => "tplID",
        self::CAR_ID   => "carID",
        self::GET_TIME => "getTime",
        self::PARAMS   => "params",
    );

    public int $playerID = 0;

    public int    $uid;
    public int    $tplID;   // 改装模板ID
    public int    $carID;
    public int    $getTime; // 获取时间
    public string $params;  // 改装参数

    public function __construct(
        int $playerID, int $uid = 0,  int $tplID = 0, int $carID = 0, int $getTime = 1, string $params = ''
    ) {
        $this->playerID = $playerID;
        $this->uid = $uid;
        $this->tplID = $tplID;
        $this->carID = $carID;
        $this->getTime = $getTime;
        $this->params = $params;
    }

    public function searchExteriorRefit():bool {
        $refit = [];
        if(!$this->searchTitle(DBTableDefine::TABLE_EXTERIOR_REFIT, $this->playerID, $this->uid,
            $refit)) {
            return false;
        }
        if (empty($refit)) {
            return false;
        }
        $this->setTplID((int)$refit[self::TPL_ID]);
        $this->setGetTime((int)$refit[self::GET_TIME]);
        $this->setCarID((int)$refit[self::CAR_ID]);
        $this->setParams($refit[self::PARAMS]);
        return true;
    }

    //搜索改装数据
    public function searchExteriorRefitArr()
    {
        $refit = [];
        $ret = [];
        if(!$this->searchTitle(DBTableDefine::TABLE_EXTERIOR_REFIT, $this->playerID, $this->uid, $refit)) {
            return false;
        }
        if (empty($refit)) {
            return false;
        }
        foreach(self::DB_KEY_MAP as $key => $val){
            if (!isset($car[$key])){
                if($key != self::PARAMS) {
                    $ret[$key] = 0;
                } else {
                    $ret[$key] = '';
                }
            }else{
                $ret[$key] = $refit[$key];
            }
        }
        return $ret;
    }

    // 通过改装件id 查询改装数据
    public function getERDataByRefitID(int $refitId): array
    {
        $refit = [];
        if(!$this->searchRank(
            DBTableDefine::TABLE_EXTERIOR_REFIT,
            $this->playerID,
            $refitId,
            $refitId,
            $refit)
        ) {
            return [];
        }
        return $refit;
    }


    public function createCarExteriorRefit(): bool
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            $data[$k] = $this->$v;
        }

        if(!$this->createTitle(DBTableDefine::TABLE_EXTERIOR_REFIT, $this->playerID, $this->uid, $data,
            $this->tplID)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_CREATE_ERROR,
                '[exteriorRefitData] car exterior refit create error!', $data
            );
            return false;
        }
        return true;
    }

    public function saveDB(): bool
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            $data[$k] = $this->$v;
        }
        if(!$this->updateTitle(DBTableDefine::TABLE_EXTERIOR_REFIT, $this->playerID, $this->uid, $data)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[exteriorRefitData] car exterior refit update error!', $data
            );
            return false;
        }
        return true;
    }

    public function deleteExteriorRefit(): bool {
        if(!$this->deleteTitle(DBTableDefine::TABLE_EXTERIOR_REFIT, $this->playerID, $this->uid)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_DELETE_ERROR,
                '[exteriorRefitData] car exterior refit delete error!',
                ['playerID' => $this->playerID, 'uid' => $this->uid]
            );
            return false;
        }
        return true;
    }

    public function setCarID(int $carID) {
        $this->carID = $carID;
    }

    public function setTplID(int $tplID) {
        $this->tplID = $tplID;
    }

    public function setGetTime(int $getTime) {
        $this->getTime = $getTime;
    }

    public function setParams(string $params) {
        $this->params = $params;
    }
}
