<?php

/**
 * 赛车比赛统计信息,只统计PVP
 */

namespace Game\Data\Car;

use Framework\Log\LogMark;
use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;
use Game\Constant\GameErrorCode;

class CarStatisticsData
{
    use PlayerDBHandler;

    public int $playerId;

    public const MATCH_NUM = "MatchNum";    //比赛次数
    public const WIN_NUM = "WinNum";        //获胜次数,单人前三,组队团队胜利
    public const MVP_NUM = "MvpNum";
    public const ICON_NUM = "IconNum";      //获得奖牌次数--对应车型
    public const MAX_WIN_NUM = "MaxWinNum"; //最大连胜次数
    public const LAST_WIN_NUM = "LastWinNum"; //当前连胜次数    0败大于0为当前连胜数
    public const LAST_MVP_FLAG = "LastMvpFlag"; //上次获得MVP标志 0否1是

    public const LAST_FAIL = 0;     //上次比赛失败
    public const LAST_GET_MVP = 1;  //上次比赛获得mvp
    public const LAST_LOSE_MVP = 0; //上次比赛未获得mvp

    public const DB_KEY_MAP = array(
        self::MATCH_NUM,
        self::WIN_NUM,
        self::MVP_NUM,
        self::ICON_NUM,
        self::MAX_WIN_NUM,
        self::LAST_WIN_NUM,
        self::LAST_MVP_FLAG,
    );

    public function __construct(int $playerId)
    {
        $this->playerId = $playerId;
    }

    public function searchDBByCarId(int $carId): ?array
    {
        $arr = [];
        if(!$this->searchRank(
            DBTableDefine::TABLE_CAR,
            $this->playerId,
            $carId,
            $carId,
            $arr)
        ) {
            return null;
        }
        if(empty($arr)) {
            return null;
        }
        foreach ($arr as $carUid => $score) {
            return $this->searchDBByCarUId($carUid);
        }
        return null;
    }

    public function searchDBByCarUId(int $carUid): ?array
    {
        $car = [];
        if(!$this->searchTitle(
            DBTableDefine::TABLE_CAR,
            $this->playerId,
            $carUid,
            $car)
        ) {
            return null;
        }
        if (empty($car)) {
            return null;
        }
        return $this->formatData($car);
    }

    public function initData(int $carUid): array
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $key) {
            $data[$key] = 0;
        }
        $this->saveDB($data, $carUid);
        return $data;
    }

    public function saveDB(array $data, int $carUid): bool
    {
        if(!$this->updateTitle(
            DBTableDefine::TABLE_CAR,
            $this->playerId,
            $carUid,
            $data)
        ) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[CarStatisticsData] car update error!', $data
            );
            return false;
        }
        return true;
    }

    private function formatData(array $array): array
    {
        $data = array();
        foreach ($array as $key => $value) {
            if (in_array($key, self::DB_KEY_MAP)) {
                $data[$key] = (int)$value;
            }
            if ($key == CarData::CAR_ID) {
                $data[$key] = (int)$value;
            }
        }
        return $data;
    }
}
