<?php

/**
 * 新车通知,临时用
 */

namespace Game\Data\Car;

use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;

class CarNoticeData
{
    use PlayerDBHandler;

    public int $playerId;

    public const NEW_CAT_NOTICE = "NewCarNotice";   //新车通知列表[carId,..]

    public function __construct(int $playerId)
    {
        $this->playerId = $playerId;
    }

    public function searchDB(): array
    {
        $result = array();
        if (!$this->searchTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            $result)
        ) {
            return [];
        }
        if (empty($result)) {
            return [];
        }
        return isset($result[self::NEW_CAT_NOTICE]) ?
            json_decode($result[self::NEW_CAT_NOTICE], true) :
            [];
    }

    public function updateDB(array $newCarNotice): bool
    {
        $data = array(
            self::NEW_CAT_NOTICE => json_encode($newCarNotice)
        );
        return $this->updateTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            $data
        );
    }
}
