<?php
/**
 * 汽车外观改装
 * @date 2022-5-16
 * @author leeFx
 **/


namespace Game\Data\Car;


use Framework\Lib\Utils;
use Framework\Log\LogMark;
use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;
use Game\Constant\GameErrorCode;

class CarExteriorData
{
    use PlayerDBHandler;

    // car 绑定 外观参数格式  tplID*getTime*1 | tplID*getTime ...
    public const DB_SEPARATION_1 = '|';
    public const DB_SEPARATION_2 = '*';

    public const DB_EXTERIOR_NOT  = 0;    // 未使用
    public const DB_EXTERIOR_TRUE  = 1;   // 使用

    public const DB_UID = 'id';        // 改装件uid
    public const DB_GET_TIME = 'getTime';   // 获得时间
    public const DB_IS_USE = 'use';    // 0 未使用 1 使用中
    public const DB_SORT = 'sort';       // 排序 0 1 2 ...
    public const DB_POSITION = 'position';   // 位置参数

    public const DB_SKIN          = 'Skin';          // 皮肤
    public const DB_PAINT         = 'Paint';         // 车漆
    public const DB_TAIL          = 'Tail';          // 尾翼
    public const DB_HOOD          = 'Hood';          // 引擎盖
    public const DB_STICKER       = 'Sticker';       // 贴纸
    public const DB_LIGHT_STRIP   = 'LightStrip';    // 灯带
    public const DB_ORNAMENTS     = 'Ornaments';     // 挂饰
    public const DB_TIRE          = 'Tire';          // 轮胎
    public const DB_NITROGEN      = 'Nitrogen';      // 氮气
    public const DB_HUB           = 'Hub';           // 轮毂
    public const DB_LICENSE_IMAGE = 'LicenseImage';  // 车牌背景图
    public const DB_LICENCE       = 'Licence';       // 号牌

    public const DB_SAVE_MAP = array(
        self::DB_SKIN          => "Skin",
        self::DB_PAINT         => "Paint",
        self::DB_TAIL          => "Tail",
        self::DB_HOOD          => "Hood",
        self::DB_STICKER       => "Sticker",
        self::DB_LIGHT_STRIP   => "LightStrip",
        self::DB_ORNAMENTS     => "Ornaments",
        self::DB_TIRE          => "Tire",
        self::DB_NITROGEN      => "Nitrogen",
        self::DB_HUB           => "Hub",
        self::DB_LICENSE_IMAGE => "LicenseImage",
        self::DB_LICENCE       => "Licence",
    );

    public const DB_KEY_MAP = array(
        self::DB_SKIN          => "skin",
        self::DB_PAINT         => "paint",
        self::DB_TAIL          => "tail",
        self::DB_HOOD          => "hood",
        self::DB_STICKER       => "sticker",
        self::DB_LIGHT_STRIP   => "lightStrip",
        self::DB_ORNAMENTS     => "ornaments",
        self::DB_TIRE          => "tire",
        self::DB_NITROGEN      => "nitrogen",
        self::DB_HUB           => "hub",
        self::DB_LICENSE_IMAGE => "licenseImage",
        self::DB_LICENCE       => "licence",
    );

    public int $playerId = 0;
    public int $uid;

    public string $skin         = '';
    public string $paint        = '';
    public int    $tail         = 0;
    public int    $hood         = 0;
    public string $sticker      = '';
    public string $lightStrip   = '';
    public string $ornaments    = '';
    public int    $tire         = 0;
    public int    $nitrogen     = 0;
    public int    $hub          = 0;
    public int    $licenseImage = 0;
    public int    $licence      = 0;

    public function __construct(int $playerId, int $uid=0)
    {
        $this->playerId = $playerId;
        $this->uid = $uid;
    }

    public function searchExterior():bool {
        $carRefit = [];
        if(!$this->searchTitle(DBTableDefine::TABLE_CAR, $this->playerId, $this->uid,
            $carRefit)) {
            return false;
        }
        if (empty($carRefit)) {
            return false;
        }
        if(isset($carRefit[self::DB_SKIN])) {
            $this->setSkin($carRefit[self::DB_SKIN]);
            $this->setPaint($carRefit[self::DB_PAINT]);
            $this->setTail(intval($carRefit[self::DB_TAIL]));
            $this->setHood(intval($carRefit[self::DB_HOOD]));
            $this->setSticker($carRefit[self::DB_STICKER]);
            $this->setLightStrip($carRefit[self::DB_LIGHT_STRIP]);
            $this->setOrnaments($carRefit[self::DB_ORNAMENTS]);
            $this->setTire(intval($carRefit[self::DB_TIRE]));
            $this->setNitrogen(intval($carRefit[self::DB_NITROGEN]));
            $this->setHub(intval($carRefit[self::DB_HUB]));
            $this->setLicenseImage(intval($carRefit[self::DB_LICENSE_IMAGE]));
            $this->setLicence(intval($carRefit[self::DB_LICENCE]));
        }
        return true;
    }

    //搜索外观改装数据
    public function searchExteriorArr()
    {
        $car = [];
        $ret = [];
        if(!$this->searchTitle(DBTableDefine::TABLE_CAR, $this->playerId, $this->uid, $car)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[exteriorData] get car exterior error!'
            );
            return $ret;
        }
        if (empty($car)) {
            return $ret;
        }
        foreach(self::DB_KEY_MAP as $key => $val){
            if (!isset($car[$key])){
                if(in_array($key, [self::DB_STICKER, self::DB_ORNAMENTS])) {
                    $ret[$key] = '';
                } else {
                    $ret[$key] = 0;
                }
            }else{
                $ret[$key] = $car[$key];
            }
        }
        return $ret;
    }

    //查询车装备的改装件ItemId
    public function getCarExteriorItemIdArr(): array
    {
        $car = [];
        $ret = [];
        if(!$this->searchTitle(
            DBTableDefine::TABLE_CAR,
            $this->playerId,
            $this->uid,
            $car)
        ) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[CarExteriorData] get car exterior error!'
            );
            return $ret;
        }
        if (empty($car)) {
            return $ret;
        }
        $exteriorUIds = array();
        foreach(self::DB_KEY_MAP as $key => $val){
            if (is_numeric($car[$key])) {
                if ((int)$car[$key] != 0) {
                    $exteriorUIds[] = (int)$car[$key];
                }
            } elseif (Utils::IsJson($car[$key])) {
                $strArr = json_decode($car[$key], true);
                foreach ($strArr as $item) {
                    $exteriorUIds[] = (int)($item[self::DB_UID]);
                }
            }
        }
        if (empty($exteriorUIds)) {
            return $exteriorUIds;
        }
        //查询uid->itemId
        $refit = [];
        if(!$this->searchRankByIndex(
            DBTableDefine::TABLE_EXTERIOR_REFIT,
            $this->playerId,
            0,
            -1,
            $refit)
        ) {
            return array();
        }
        return array_values($refit);
    }

    //更新车辆的外观改装属性
    public function saveDB($data): bool
    {
        if(!$this->updateTitle(DBTableDefine::TABLE_CAR, $this->playerId, $this->uid, $data)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[exteriorData] car exterior update error!', $data
            );
            return false;
        }
        return true;
    }

    public function createDB(): bool
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            $data[$k] = $this->$v;
        }
        if (!$this->saveDB($data)){
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[exteriorData] save car exterior error!', $data
            );
            return false;
        }
        return true;
    }

    //更新数据
    public function updateDB(): bool
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            if (empty($this->$v)){
                continue;
            }
            $data[$k] = $this->$v;
        }
        if (!$this->saveDB($data)){
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[exteriorData] update car exterior error!', $data
            );
            return false;
        }
        return true;
    }

    //查询改装件是否存在 true存在
    public function checkHasRefitId(int $refitId): bool
    {
        $refit = [];
        if(!$this->searchRankByIndex(
            DBTableDefine::TABLE_EXTERIOR_REFIT,
            $this->playerId,
            0,
            -1,
            $refit)
        ) {
            return false;
        }
        foreach ($refit as $key => $value) {
            if ($refitId == $value) {
                return true;
            }
        }
        return false;
    }

    public function setSkin(string $skin)
    {
        $this->skin = $skin;
    }

    public function setPaint(string $paint)
    {
        $this->paint = $paint;
    }

    public function setTail(int $tail)
    {
        $this->tail = $tail;
    }

    public function setHood(int $hood)
    {
        $this->hood = $hood;
    }

    public function setSticker(string $sticker)
    {
        $this->sticker = $sticker;
    }

    public function setLightStrip(string $lightStrip)
    {
        $this->lightStrip = $lightStrip;
    }

    public function setOrnaments(string $ornaments)
    {
        $this->ornaments = $ornaments;
    }

    public function setTire(int $tire)
    {
        $this->tire = $tire;
    }

    public function setNitrogen(int $nitrogen)
    {
        $this->nitrogen = $nitrogen;
    }

    public function setHub(int $hub)
    {
        $this->hub = $hub;
    }

    public function setLicenseImage(string $licenseImage)
    {
        $this->licenseImage = $licenseImage;
    }

    public function setLicence(string $licence)
    {
        $this->licence = $licence;
    }
}