<?php
/**
 * 汽车改装模块
 * @date 2022-3-22
 * @author JZW
 **/


namespace Game\Data\Car;


use Framework\Log\LogMark;
use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;
use Game\Constant\GameErrorCode;

class CarDeepmodData
{
    use PlayerDBHandler;

    public const DB_BASE_SPEED1 = "BaseSpeed1";                       // 基础最高速度
    public const DB_BASE_SPEED2 = "BaseSpeed2";                       // 基础最高速度
    public const DB_BASE_SPEED3 = "BaseSpeed3";                       // 基础最高速度
    public const DB_NITROGEN_SPEED1 = "NitrogenSpeed1";               // 氮气最高速度
    public const DB_NITROGEN_SPEED2 = "NitrogenSpeed2";               // 氮气最高速度
    public const DB_NITROGEN_SPEED3 = "NitrogenSpeed3";               // 氮气最高速度
    public const DB_JET_SPEED1 = "JetSpeed1";                         // 小喷最高速度
    public const DB_JET_SPEED2 = "JetSpeed2";                         // 小喷最高速度
    public const DB_JET_SPEED3 = "JetSpeed3";                         // 小喷最高速度
    public const DB_BASE_ACCELERATE1 = "BaseAccelerate1";             // 基础加速度
    public const DB_BASE_ACCELERATE2 = "BaseAccelerate2";             // 基础加速度
    public const DB_BASE_ACCELERATE3 = "BaseAccelerate3";             // 基础加速度
    public const DB_NITROGEN_ACCELERATE1 = "NitrogenAccelerate1";     // 氮气加速度
    public const DB_NITROGEN_ACCELERATE2 = "NitrogenAccelerate2";     // 氮气加速度
    public const DB_NITROGEN_ACCELERATE3 = "NitrogenAccelerate3";     // 氮气加速度
    public const DB_JET_ACCELERATE1 = "JetAccelerate1";               // 小喷加速度
    public const DB_JET_ACCELERATE2 = "JetAccelerate2";               // 小喷加速度
    public const DB_JET_ACCELERATE3 = "JetAccelerate3";               // 小喷加速度
    public const DB_NITROGEN_TIME1 = "NitrogenTime1";                 // 氮气时间
    public const DB_NITROGEN_TIME2 = "NitrogenTime2";                 // 氮气时间
    public const DB_NITROGEN_TIME3 = "NitrogenTime3";                 // 氮气时间
    public const DB_JET_TIME1 = "JetTime1";                           // 小喷时间
    public const DB_JET_TIME2 = "JetTime2";                           // 小喷时间
    public const DB_JET_TIME3 = "JetTime3";                           // 小喷时间
    public const DB_NITROGEN_ACCUMULATION1 = "NitrogenAccumulation1"; // 氮气积累系数
    public const DB_NITROGEN_ACCUMULATION2 = "NitrogenAccumulation2"; // 氮气积累系数
    public const DB_NITROGEN_ACCUMULATION3 = "NitrogenAccumulation3"; // 氮气积累系数

    //若单一个属性词条连续3次为负增长时，下次改装数值为区间上限
    public const DB_RANDOM_ATTR = "RandomAttr";  //随机属性负数次数  json格式id:num

    public int $playerId = 0;
    public int $uid;


    public float $baseSpeed1 = 0;
    public float $baseSpeed2 = 0;
    public float $baseSpeed3 = 0;
    public float $nitrogenSpeed1 = 0;
    public float $nitrogenSpeed2 = 0;
    public float $nitrogenSpeed3 = 0;
    public float $jetSpeed1 = 0;
    public float $jetSpeed2 = 0;
    public float $jetSpeed3 = 0;
    public float $baseAccelerate1 = 0;
    public float $baseAccelerate2 = 0;
    public float $baseAccelerate3 = 0;
    public float $nitrogenAccelerate1 = 0;
    public float $nitrogenAccelerate2 = 0;
    public float $nitrogenAccelerate3 = 0;
    public float $jetAccelerate1 = 0;
    public float $jetAccelerate2 = 0;
    public float $jetAccelerate3 = 0;
    public float $nitrogenTime1 = 0;
    public float $nitrogenTime2 = 0;
    public float $nitrogenTime3 = 0;
    public float $jetTime1 = 0;
    public float $jetTime2 = 0;
    public float $jetTime3 = 0;
    public float $nitrogenAccumulation1 = 0;
    public float $nitrogenAccumulation2 = 0;
    public float $nitrogenAccumulation3 = 0;
    public string $randomAttr = "[]";


    public const DB_KEY_MAP = array(
        self::DB_BASE_SPEED1 => "baseSpeed1",
        self::DB_BASE_SPEED2 => "baseSpeed2",
        self::DB_BASE_SPEED3 => "baseSpeed3",
        self::DB_NITROGEN_SPEED1 => "nitrogenSpeed1",
        self::DB_NITROGEN_SPEED2 => "nitrogenSpeed2",
        self::DB_NITROGEN_SPEED3 => "nitrogenSpeed3",
        self::DB_JET_SPEED1 => "jetSpeed1",
        self::DB_JET_SPEED2 => "jetSpeed2",
        self::DB_JET_SPEED3 => "jetSpeed3",
        self::DB_BASE_ACCELERATE1 => "baseAccelerate1",
        self::DB_BASE_ACCELERATE2 => "baseAccelerate2",
        self::DB_BASE_ACCELERATE3 => "baseAccelerate3",
        self::DB_NITROGEN_ACCELERATE1 => "nitrogenAccelerate1",
        self::DB_NITROGEN_ACCELERATE2 => "nitrogenAccelerate2",
        self::DB_NITROGEN_ACCELERATE3 => "nitrogenAccelerate3",
        self::DB_JET_ACCELERATE1 => "jetAccelerate1",
        self::DB_JET_ACCELERATE2 => "jetAccelerate2",
        self::DB_JET_ACCELERATE3 => "jetAccelerate3",
        self::DB_NITROGEN_TIME1 => "nitrogenTime1",
        self::DB_NITROGEN_TIME2 => "nitrogenTime2",
        self::DB_NITROGEN_TIME3 => "nitrogenTime3",
        self::DB_JET_TIME1 => "jetTime1",
        self::DB_JET_TIME2 => "jetTime2",
        self::DB_JET_TIME3 => "jetTime3",
        self::DB_NITROGEN_ACCUMULATION1 => "nitrogenAccumulation1",
        self::DB_NITROGEN_ACCUMULATION2 => "nitrogenAccumulation2",
        self::DB_NITROGEN_ACCUMULATION3 => "nitrogenAccumulation3",
        self::DB_RANDOM_ATTR => "randomAttr",
    );

    public const DB_KEY_MAP_TEMPLE = array(
        1 => self::DB_BASE_SPEED1,
        2 => self::DB_BASE_SPEED2,
        3 => self::DB_BASE_SPEED3,
        4 => self::DB_NITROGEN_SPEED1,
        5 => self::DB_NITROGEN_SPEED2,
        6 => self::DB_NITROGEN_SPEED3,
        7 => self::DB_JET_SPEED1,
        8 => self::DB_JET_SPEED2,
        9 => self::DB_JET_SPEED3,
        10 => self::DB_BASE_ACCELERATE1,
        11 => self::DB_BASE_ACCELERATE2,
        12 => self::DB_BASE_ACCELERATE3,
        13 => self::DB_NITROGEN_ACCELERATE1,
        14 => self::DB_NITROGEN_ACCELERATE2,
        15 => self::DB_NITROGEN_ACCELERATE3,
        16 => self::DB_JET_ACCELERATE1,
        17 => self::DB_JET_ACCELERATE2,
        18 => self::DB_JET_ACCELERATE3,
        19 => self::DB_NITROGEN_TIME1,
        20 => self::DB_NITROGEN_TIME2,
        21 => self::DB_NITROGEN_TIME3,
        22 => self::DB_JET_TIME1,
        23 => self::DB_JET_TIME2,
        24 => self::DB_JET_TIME3,
        25 => self::DB_NITROGEN_ACCUMULATION1,
        26 => self::DB_NITROGEN_ACCUMULATION2,
        27 => self::DB_NITROGEN_ACCUMULATION3,
    );

    // id => sys
    public const DB_TABLE_MAP = [
        1  => 1,
        2  => 2,
        3  => 3,
        4  => 1,
        5  => 2,
        6  => 3,
        7  => 1,
        8  => 2,
        9  => 3,
        10 => 1,
        11 => 2,
        12 => 3,
        13 => 1,
        14 => 2,
        15 => 3,
        16 => 1,
        17 => 2,
        18 => 3,
        19 => 1,
        20 => 2,
        21 => 3,
        22 => 1,
        23 => 2,
        24 => 3,
        25 => 1,
        26 => 2,
        27 => 3,
    ];

    // id => type
    public const DB_TABLE_TYPE_MAP = [
        1  => 1,
        2  => 1,
        3  => 1,
        4  => 2,
        5  => 2,
        6  => 2,
        7  => 3,
        8  => 3,
        9  => 3,
        10 => 4,
        11 => 4,
        12 => 4,
        13 => 5,
        14 => 5,
        15 => 5,
        16 => 6,
        17 => 6,
        18 => 6,
        19 => 7,
        20 => 7,
        21 => 7,
        22 => 8,
        23 => 8,
        24 => 8,
        25 => 9,
        26 => 9,
        27 => 9,
    ];
    // sys => [ type => id ]
    public const DB_SYS_TYPE = [
        1 => [
            1 => 1,
            2 => 4,
            3 => 7,
            4 => 10,
            5 => 13,
            6 => 16,
            7 => 19,
            8 => 22,
            9 => 25,
        ],
        2 => [
            1 => 2,
            2 => 5,
            3 => 8,
            4 => 11,
            5 => 14,
            6 => 17,
            7 => 20,
            8 => 23,
            9 => 26,
        ],
        3 => [
            1 => 3,
            2 => 6,
            3 => 9,
            4 => 12,
            5 => 15,
            6 => 18,
            7 => 21,
            8 => 24,
            9 => 27,
        ]
    ];

    public function __construct(int $playerId, int $uid=0)
    {
        $this->playerId = $playerId;
        $this->uid = $uid;
    }

    //搜索改装数据
    public function searchRefit()
    {
        $car = [];
        $ret = [];
        if(!$this->searchTitle(DBTableDefine::TABLE_CAR, $this->playerId, $this->uid, $car)) {
            return false;
        }
        if (empty($car)) {
            return false;
        }
        foreach(self::DB_KEY_MAP as $key => $val){
            if (!isset($car[$key])){
                $ret[$key] = 0;
            }else{
                $ret[$key] = $car[$key];
            }
        }
        return $ret;
    }

    //更新车辆的改装属性
    private function saveDB($data): bool
    {
        if(!$this->updateTitle(DBTableDefine::TABLE_CAR, $this->playerId, $this->uid, $data)) {
            LogMark::getInstance()->markError(
                GameErrorCode::DATA_UPDATE_ERROR,
                '[data] car update error!', $data
            );
            return false;
        }
        return true;
    }
    //创建数据
    public function createDB(): bool
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            $data[$k] = $this->$v;
        }
        if (!$this->saveDB($data)){
            return false;
        }
        return true;
    }
    //更新数据
    public function updateDB(): bool
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            if (empty($this->$v)){
                continue;
            }
            $data[$k] = $this->$v;
        }
        if (!$this->saveDB($data)){
            return false;
        }
        return true;
    }

    /**
     * @param float|int $nitrogenAccumulation
     */
    public function setNitrogenAccumulation1($nitrogenAccumulation): void
    {
        $this->nitrogenAccumulation1 = $nitrogenAccumulation;
    }
    /**
     * @param float|int $nitrogenAccumulation
     */
    public function setNitrogenAccumulation2($nitrogenAccumulation): void
    {
        $this->nitrogenAccumulation2 = $nitrogenAccumulation;
    }
    /**
     * @param float|int $nitrogenAccumulation
     */
    public function setNitrogenAccumulation3($nitrogenAccumulation): void
    {
        $this->nitrogenAccumulation3 = $nitrogenAccumulation;
    }

    /**
     * @param float|int $jetTime
     */
    public function setJetTime1($jetTime): void
    {
        $this->jetTime1 = $jetTime;
    }
    /**
     * @param float|int $jetTime
     */
    public function setJetTime2($jetTime): void
    {
        $this->jetTime2 = $jetTime;
    }
    /**
     * @param float|int $jetTime
     */
    public function setJetTime3($jetTime): void
    {
        $this->jetTime3 = $jetTime;
    }

    /**
     * @param float|int $nitrogenTime
     */
    public function setNitrogenTime1($nitrogenTime): void
    {
        $this->nitrogenTime1 = $nitrogenTime;
    }
    /**
     * @param float|int $nitrogenTime
     */
    public function setNitrogenTime2($nitrogenTime): void
    {
        $this->nitrogenTime2 = $nitrogenTime;
    }
    /**
     * @param float|int $nitrogenTime
     */
    public function setNitrogenTime3($nitrogenTime): void
    {
        $this->nitrogenTime3 = $nitrogenTime;
    }

    /**
     * @param float|int $jetAccelerate
     */
    public function setJetAccelerate1($jetAccelerate): void
    {
        $this->jetAccelerate1 = $jetAccelerate;
    }
    /**
     * @param float|int $jetAccelerate
     */
    public function setJetAccelerate2($jetAccelerate): void
    {
        $this->jetAccelerate2 = $jetAccelerate;
    }
    /**
     * @param float|int $jetAccelerate
     */
    public function setJetAccelerate3($jetAccelerate): void
    {
        $this->jetAccelerate3 = $jetAccelerate;
    }

    /**
     * @param float|int $nitrogenAccelerate
     */
    public function setNitrogenAccelerate1($nitrogenAccelerate): void
    {
        $this->nitrogenAccelerate1 = $nitrogenAccelerate;
    }
    /**
     * @param float|int $nitrogenAccelerate
     */
    public function setNitrogenAccelerate2($nitrogenAccelerate): void
    {
        $this->nitrogenAccelerate2 = $nitrogenAccelerate;
    }
    /**
     * @param float|int $nitrogenAccelerate
     */
    public function setNitrogenAccelerate3($nitrogenAccelerate): void
    {
        $this->nitrogenAccelerate3 = $nitrogenAccelerate;
    }

    /**
     * @param float|int baseAccelerate
     */
    public function setBaseAccelerate1($baseAccelerate): void
    {
        $this->baseAccelerate1 = $baseAccelerate;
    }
    /**
     * @param float|int $baseAccelerate
     */
    public function setBaseAccelerate2($baseAccelerate): void
    {
        $this->baseAccelerate2 = $baseAccelerate;
    }
    /**
     * @param float|int $baseAccelerate
     */
    public function setBaseAccelerate3($baseAccelerate): void
    {
        $this->baseAccelerate3 = $baseAccelerate;
    }

    /**
     * @param float|int nitrogenSpeed
     */
    public function setNitrogenSpeed1($nitrogenSpeed): void
    {
        $this->nitrogenSpeed1 = $nitrogenSpeed;
    }
    /**
     * @param float|int $nitrogenSpeed
     */
    public function setNitrogenSpeed2($nitrogenSpeed): void
    {
        $this->nitrogenSpeed2 = $nitrogenSpeed;
    }
    /**
     * @param float|int $nitrogenSpeed
     */
    public function setNitrogenSpeed3($nitrogenSpeed): void
    {
        $this->nitrogenSpeed3 = $nitrogenSpeed;
    }

    /**
     * @param float|int $jetspeed
     */
    public function setJetSpeed1($jetspeed): void
    {
        $this->jetSpeed1 = $jetspeed;
    }
    /**
     * @param float|int $jetspeed
     */
    public function setJetSpeed2($jetspeed): void
    {
        $this->jetSpeed2 = $jetspeed;
    }
    /**
     * @param float|int $jetspeed
     */
    public function setJetSpeed3($jetspeed): void
    {
        $this->jetSpeed3 = $jetspeed;
    }

    /**
     * @param float|int $baseSpeed
     */
    public function setBaseSpeed1($baseSpeed): void
    {
        $this->baseSpeed1 = $baseSpeed;
    }
    /**
     * @param float|int $baseSpeed
     */
    public function setBaseSpeed2($baseSpeed): void
    {
        $this->baseSpeed2 = $baseSpeed;
    }
    /**
     * @param float|int $baseSpeed
     */
    public function setBaseSpeed3($baseSpeed): void
    {
        $this->baseSpeed3 = $baseSpeed;
    }

    /**
     * @param string $randomAttr
     */
    public function setRandomAttr(string $randomAttr): void
    {
        $this->randomAttr = $randomAttr;
    }
}