<?php

/**
 * 限时任务登录
 */

namespace Game\Data\Activity;

use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;

class TaskExchangeLoginData
{
    use PlayerDBHandler;

    public const LOGIN_RECORD = "LoginRecord";    // 登录记录
    public const LOGIN_REWARD_RECORD = "RewardRecord";    // 登录领取记录


    public const DB_KEY_MAP = [
        self::LOGIN_RECORD => "loginRecord",
        self::LOGIN_REWARD_RECORD => "rewardRecord",
    ];

    public int $playerID = 0;
    public array $loginRecord = [];
    public array $rewardRecord = [];


    public function searchDB($titleID): bool
    {
        $result = array();
        if (!$this->searchTitle(
            DBTableDefine::TABLE_TASK_EXCHANGE_LOGIN,
            $this->playerID,
            $titleID,
            $result)
        ) {
            return false;
        }
        foreach ($result as $k => $v) {
            $this->setDBData($k, $v);
        }
        return true;
    }

    public function updateDB($titleID): bool
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            if (is_numeric($this->$v)) {
                $data[$k] = $this->$v;
            } else {
                $data[$k] = json_encode($this->$v);
            }
        }
        return $this->updateTitle(
            DBTableDefine::TABLE_TASK_EXCHANGE_LOGIN,
            $this->playerID,
            $titleID,
            $data
        );
    }

    private function setDBData($key, $value)
    {
        if (!array_key_exists($key, self::DB_KEY_MAP)) {
            return;
        }
        $property = self::DB_KEY_MAP[$key];
        if (is_numeric($this->$property)) {
            $this->$property = (int)$value;
        } else {
            $this->$property = json_decode($value, true);
        }
    }
}
