<?php

/**
 * 地图挑战赛
 */

namespace Game\Data\Activity;

use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;

class MapChallengeData
{
    use PlayerDBHandler;

    public int $playerId;
    public int $activityId;

    public function __construct($playerId, $activityId)
    {
        $this->playerId = $playerId;
        $this->activityId = $activityId;
    }

    public const REWARD_STATUS = "RewardStatus";   //大奖状态
    public const ALL_REWARD_GET_STATUS = "AllRewardGetStatus";  //全部奖励领取状态
    public const ALL_REWARD_GET_TIME = "AllRewardGetTime";      //全部奖励领取时间

    //根据mapId组合key
    private const MAP_BEST_TIME = "MapBestTime";    //地图最佳时间
    private const MAP_COMPLETE_TASK_NUM = "MapCompleteTaskNum";  //完成挑战数量
    private const MAP_ALL_COMPLETE_FLAG = "MapAllCompleteFlag"; //全部完成标志
    private const MAP_CAN_GET_REWARD_ID = "MapCanGetRewardId";  //可领取的奖励id
    private const MAP_ALREADY_GET_REWARD_ID = "MapAlreadyGetRewardId";  //已领取的奖励id

    public const REWARD_STATUS_CAN_NOT_GET = 0; //大奖状态--不可领取
    public const REWARD_STATUS_CAN_GET = 1;     //大奖状态--可领取
    public const REWARD_STATUS_ALREADY_GET = 2; //大奖状态--已领取

    public const ALL_REWARD_GET_STATUS_DOING = 0;   //全部奖励领取状态--未全部领取
    public const ALL_REWARD_GET_STATUS_OVER = 1;    //全部奖励领取状态--已全部领取

    public const MAP_ALL_COMPLETE_FLAG_DOING = 0; //未全部完成
    public const MAP_ALL_COMPLETE_FLAG_OVER = 1;  //全部完成

    //初始数据 大奖状态等
    public function initData(): array
    {
        return array(
            self::REWARD_STATUS => self::REWARD_STATUS_CAN_NOT_GET,
            self::ALL_REWARD_GET_STATUS => self::ALL_REWARD_GET_STATUS_DOING,
            self::ALL_REWARD_GET_TIME => 0,
        );
    }

    //根据mapId获取对应map参数
    public static function getMapKey(int $mapId): array
    {
        return array(
            self::MAP_BEST_TIME . $mapId,
            self::MAP_COMPLETE_TASK_NUM . $mapId,
            self::MAP_ALL_COMPLETE_FLAG . $mapId,
            self::MAP_CAN_GET_REWARD_ID . $mapId,
            self::MAP_ALREADY_GET_REWARD_ID . $mapId,
        );
    }

    public function getMapKeyValue(int $mapId, array $dbData): array
    {
        $data = array();
        foreach (self::getMapKey($mapId) as $key) {
            $data[$key] = $dbData[$key] ?? 0;
        }
        return $data;
    }

    public function saveDB(array $data): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_ACTIVITY_MAP_CHALLENGE,
            $this->playerId,
            $this->activityId,
            $data
        );
    }

    public function getDataFromDB(): array
    {
        $result = array();
        if (!$this->searchTitle(
            DBTableDefine::TABLE_ACTIVITY_MAP_CHALLENGE,
            $this->playerId,
            $this->activityId,
            $result
        )) {
            return array();
        }
        $data = array();
        foreach ($result as $key => $value) {
            $data[$key] = (int)$value;
        }
        return $data;
    }
}
