<?php

/**
 * 活跃度
 */

namespace Game\Data;

use Framework\DB\Handler\PlayerDBHandler;
use Framework\DB\Handler\PlayerDBPipe;
use Framework\Lib\Utils;
use Framework\Logic\TemplateHelp;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\DBTableDefine;
use Game\Constant\TemplateDefine;

class ActiveData
{
    use PlayerDBHandler;
    use TemplateHelp;

    public int $playerId;

    public const ActivePoint = "ActivePoint";   //活跃度
    public const ActiveId = "ActiveId";         //活跃度领取进度
    public const RefreshNum = "RefreshNum";     //挑战任务刷新次数
    public const RefreshTime = "RefreshTime";   //刷新时间,重置活跃度使用

    public const DB_KEY_MAP = array(
        self::ActivePoint => "activePoint",
        self::ActiveId => "activeId",
        self::RefreshNum => "refreshNum",
        self::RefreshTime => "refreshTime"
    );

    public int $activePoint = 0;
    public int $activeId = 0;
    public int $refreshNum;
    public int $refreshTime;

    public function __construct($playerId)
    {
        $this->playerId = $playerId;
    }

    public function initActive()
    {
        $this->activePoint = 0;
        $this->activeId = 0;
        $this->refreshNum = (int)$this->getTerm(TemplateDefine::TYPE_CONST,
                                                     TemplateConst::Const_Task_Daily_Challenge_Refresh_Num,
                                                     TemplateConst::ConstNum);
        $this->refreshTime = Utils::getServerTimestamp();
    }

    public function resetRefreshNum()
    {
        $this->refreshNum = (int)$this->getTerm(TemplateDefine::TYPE_CONST,
                                                TemplateConst::Const_Task_Daily_Challenge_Refresh_Num,
                                                TemplateConst::ConstNum);
        $this->updateDB();
    }

    public function addActivePoint(int $num)
    {
        $this->activePoint += $num;
    }

    public function setActiveId(int $id)
    {
        $this->activeId = $id;
    }

    public function setRefreshTime()
    {
        $this->refreshTime = Utils::getServerTimestamp();
    }

    public function subRefreshNum()
    {
        $this->refreshNum--;
    }

    public function createDB(): bool
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            $data[$k] = $this->$v;
        }
        return $this->createTitle(
            DBTableDefine::TABLE_ACTIVE,
            $this->playerId,
            0,
            $data
        );
    }

    public function registerDB(): bool
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            $data[$k] = $this->$v;
        }
        return PlayerDBPipe::getInstance()->createTitle(
            DBTableDefine::TABLE_ACTIVE,
            $this->playerId,
            0,
            $data
        );
    }

    public function searchDB(): bool
    {
        $result = array();
        if (!$this->searchTitle(
            DBTableDefine::TABLE_ACTIVE,
            $this->playerId,
            0,
            $result)
        ) {
            return false;
        }
        if (empty($result)) {
            return false;
        }
        foreach ($result as $k => $v) {
            $this->setDBData($k, $v);
        }
        return true;
    }

    public function updateDB(): bool
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            $data[$k] = $this->$v;
        }
        return $this->updateTitle(
            DBTableDefine::TABLE_ACTIVE,
            $this->playerId,
            0,
            $data
        );
    }

    private function setDBData($key, $value)
    {
        if (!array_key_exists($key, self::DB_KEY_MAP)) {
            return;
        }
        $property = self::DB_KEY_MAP[$key];
        if (is_numeric($value)) {
            $this->$property = (int)$value;
        } else {
            $this->$property = $value;
        }
    }
}
