<?php

/**
 * AccountData.php
 * 文件描述
 * Created On 2022/1/18
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Game\Data;

use Framework\DB\Handler\PlayerDBHandler;
use Game\Constant\DBTableDefine;

class AccountData
{
    use PlayerDBHandler;

    public const FEMALE = 0;  //性别女
    public const MALE = 1; //性别男

    // 账号类型
    public const PLAYER_NORMAL = 0;   // 正常玩家
    public const PLAYER_GM = 1;       // GM
    public const PLAYER_GUEST = 2;    // 游客

    public const DB_ROOM_ID_DEFAULT = 0;
    public const DB_CUSTOMIZE_ROOM_ID_DEFAULT = 0;

    public const DB_ACCOUNT = "account";
    public const DB_SESSION = "sessionId";
    public const DB_LOGIN_TIME = "loginTime";
    public const DB_LOGOUT_TIME = "OfflineTime";  //离线时间
    public const DB_CLOTH_MALE = "clothMale";
    public const DB_CLOTH_FEMALE = "clothFemale";
    public const DB_CREATE_TIME = "createTime";
    public const DB_PACKET_INDEX = "packetIndex";   //packet缓存index
    public const DB_PACKET_CACHE = "packetCache";   //packet缓存
    public const DB_ACCOUNT_TYPE = "accountType";   // 账号类型
    public const DB_PASSWORD = "password";          // 账号密码
    public const DB_PASSWORD_MD5 = "passwordMD5";   // 账号密码
    public const DB_CLIENT_DATA = "clientData";     // 客户端数据

    public const DB_ROOM_ID = "roomID"; // 玩家当前所在房间ID
    public const DB_ROOM_CUSTOMIZE_ID = "roomCustomizeID"; // 玩家当前所在自定义房间ID
    public const DB_LICENCE_NUM = "licenceNum";   // 当天抽取车牌次数
    public const DB_LICENCE_DATE = "licenceDate"; // 车牌抽取时间
    public const DB_ClUB_EXIT_TIME = "clubExitTime";   // 退出俱乐部时间
    public const DB_LOGIN_NUM = "loginNum";     //登录天数
    public const DB_LOGIN_CONTINUOUS_NUM = "loginContinuousNum";   //连续登录天数
    public const DB_CARS_PERFORMANCE_SCORE = "CarsPerformanceScore";   //车辆的总性能分数
    public const DB_CAR_USE_NUM_RACE = "carUseNumRace";     //竞速车使用次数
    public const DB_CAR_USE_NUM_JAM = "carUseNumJam";       //干扰车使用次数
    public const DB_CAR_USE_NUM_HELP = "carUseNumHelp";     //辅助车使用次数
    public const DB_CUSTOMIZE_ROOM_SAVE_MAP = "customizeMapID";     // 收藏自定义房间地图
    public const DB_CONTINUITY_WIN = "continuityWin";       //连胜次数
    //收益buff
    public const DB_BUFF_DOUBLE_GOLD = "BuffDoubleGold";    //双倍金币收益->过期时间
    public const DB_BUFF_DOUBLE_PROFICIENCY = "BuffDoubleProficiency";  //双倍熟练度收益->过期时间
    public const DB_BUFF_DOUBLE_EXP = "BuffDoubleExp";  //双倍经验收益->过期时间
    public const DB_CHAPTER_ID = "UnlockChapterId";               //已解锁最大章节Id

    // role
    public const DB_STEP = "Step";                       // 创角步骤标识
    public const DB_RoleId = "RoleId";                   // 角色Id
    public const DB_LEVEL = "Level";                     // 等级
    public const DB_EXP = "Exp";
    public const DB_HEAD = "Head";                       // 头像
    public const DB_SKIN_COLOR = "SkinColor";           //肤色
    public const DB_GENDER = "Gender";                   // 性别 0女 1男
    public const DB_NICK_NAME = "NickName";              // 昵称
    public const DB_CHANGE_NICKNAME_TIME = "changeNicknameTime";    //修改昵称时间
    public const DB_DEFAULT_CAR = "DefaultCar";          // 默认车辆
    public const DB_DEFAULT_CAT_TPL = "DefaultCarTpl";   // 默认车TplId
    public const DB_ROLE_MODEL_ID = "RoleModel";         // 模型id

    public const DB_BAN_TIME = "BanTime";                // 封禁时间
    public const DB_PROHIBITION_TIME = "ProhibitionTime"; // 禁言时间

    public const DB_KEY_MAP = array(
        self::DB_ACCOUNT => "account",
        self::DB_ACCOUNT_TYPE => "accountType",
        self::DB_PASSWORD => "password",
        self::DB_PASSWORD_MD5 => "passwordMD5",
        self::DB_SESSION => "sessionId",
        self::DB_LOGIN_TIME => "loginTime",
        self::DB_CLOTH_MALE => "clothMale",
        self::DB_CLOTH_FEMALE => "clothFemale",
        self::DB_CREATE_TIME => "createTime",
        self::DB_PACKET_INDEX => "packetIndex",
        self::DB_PACKET_CACHE => "packetCache",
        self::DB_ROOM_ID => "roomID",
        self::DB_ROOM_CUSTOMIZE_ID => "roomCustomizeID",
        self::DB_LICENCE_NUM => "licenceNum",
        self::DB_LICENCE_DATE => "licenceDate",
        self::DB_ClUB_EXIT_TIME => "clubExitTime",
        self::DB_LOGIN_NUM => "loginNum",
        self::DB_LOGIN_CONTINUOUS_NUM => "loginContinuousNum",
        self::DB_CARS_PERFORMANCE_SCORE => "carsPerformanceScore",
        self::DB_CAR_USE_NUM_RACE => "carUseNumRace",
        self::DB_CAR_USE_NUM_JAM => "carUseNumJam",
        self::DB_CAR_USE_NUM_HELP => "carUseNumHelp",
        self::DB_CUSTOMIZE_ROOM_SAVE_MAP => "customizeMapID",
        self::DB_CONTINUITY_WIN => "continuityWin",
        self::DB_CLIENT_DATA => "clientData",
        self::DB_BUFF_DOUBLE_GOLD => "buffDoubleGold",
        self::DB_BUFF_DOUBLE_PROFICIENCY => "buffDoubleProficiency",
        self::DB_BUFF_DOUBLE_EXP => "buffDoubleExp",
        self::DB_CHAPTER_ID => "unlockChapterId",

        self::DB_BAN_TIME => "banTime",
        self::DB_PROHIBITION_TIME => "prohibitionTime",

        self::DB_STEP => "step",
        self::DB_RoleId => "roleId",
        self::DB_LEVEL => "level",
        self::DB_EXP => "exp",
        self::DB_HEAD => "head",
        self::DB_SKIN_COLOR => "skinColor",
        self::DB_GENDER => "gender",
        self::DB_NICK_NAME => "nickName",
        self::DB_CHANGE_NICKNAME_TIME => "changeNicknameTime",
        self::DB_DEFAULT_CAR => "defaultCar",
        self::DB_DEFAULT_CAT_TPL => "defaultCarTpl",
        self::DB_ROLE_MODEL_ID => "roleModel",
    );


    public string $account;
    public int $accountType = 0;
    public string $clientData = "";
    public string $password = "";
    public string $passwordMD5 = "";
    public int $playerId;
    public string $sessionId;
    public int $loginTime;
    public string $clothMale = "";
    public string $clothFemale = "";
    public int $createTime;
    public int $packetIndex;
    public string $packetCache;
    public int $roomID = 0;
    public int $roomCustomizeID = 0;
    public int $licenceNum = 0;
    public string $licenceDate = '';
    public int $logout = 0;
    public int $status = 0;
    public int $clubExitTime = 0;
    public int $loginNum = 1;       //初始登录天数为1
    public int $loginContinuousNum = 1;
    public int $carsPerformanceScore = 0;
    public int $carUseNumRace = 0;
    public int $carUseNumJam = 0;
    public int $carUseNumHelp = 0;
    public array $customizeMapID = [];
    private string $dbTable;
    private bool $isLoad = false;
    public int $continuityWin = 0;
    public int $buffDoubleGold = 0;
    public int $buffDoubleProficiency = 0;
    public int $buffDoubleExp = 0;
    public int $unlockChapterId = 0;

    public int $banTime = 0;
    public int $prohibitionTime = 0;

    public int $step = 0;
    public int $roleId = 0;
    public int $level = 1;
    public int $exp = 0;
    public int $head = 0;
    public int $skinColor = 0;
    public int $gender = 0;
    public string $nickName = "";
    public int $changeNicknameTime = 0;
    public int $defaultCar = 0;
    public int $defaultCarTpl = 0;
    public int $roleModel = 0;


    public function createDB(): bool
    {
        $data = $this->getDBData();
        return $this->createTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            $data
        );
    }

    public function loadFromDB($playId, &$result): bool
    {
        $this->playerId = $playId;
        $result = array();
        if (
            !$this->searchTitle(
                DBTableDefine::TABLE_ACCOUNT,
                $this->playerId,
                0,
                $result
            )
        ) {
            return false;
        }
        return true;
    }

    public function setDBData($key, $val)
    {
        if (!array_key_exists($key, self::DB_KEY_MAP)) {
            return;
        }

        $property = self::DB_KEY_MAP[$key];
        $this->$property = (int)$val;
    }

    private function getDBData(): array
    {
        $data = array();
        foreach (self::DB_KEY_MAP as $k => $v) {
            if($k == self::DB_CUSTOMIZE_ROOM_SAVE_MAP) {
                $data[$k] = json_encode($this->$v, true);
            } else {
                $data[$k] = $this->$v;
            }
        }
        return $data;
    }

    public function saveLogin(): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            array(
                self::DB_LOGIN_TIME => $this->loginTime,
                self::DB_LOGOUT_TIME => $this->logout,
            )
        );
    }

    public function saveLoginSession(): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            array(
                self::DB_SESSION => $this->sessionId,
            )
        );
    }

    public function inQuery(&$result): bool
    {
        if (!$this->searchTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            $result
        ))
        {
            return false;
        }
        return true;
    }

    public function saveFemaleDress(): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            array(
                AccountData::DB_GENDER => $this->gender,
                self::DB_CLOTH_FEMALE => $this->clothFemale,
            )
        );
    }

    public function saveMaleDress(): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            array(
                AccountData::DB_GENDER => $this->gender,
                self::DB_CLOTH_MALE => $this->clothMale,
            )
        );
    }

    public function savePacketCache(): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            array(
                self::DB_PACKET_INDEX => $this->packetIndex,
                self::DB_PACKET_CACHE => $this->packetCache
            )
        );
    }

    public function saveRoomID(): bool {
        return $this->updateTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            array(
                self::DB_ROOM_ID => $this->roomID,
            )
        );
    }

    public function saveRoomCustomizeID(): bool {
        return $this->updateTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            array(
                self::DB_ROOM_CUSTOMIZE_ID => $this->roomCustomizeID,
            )
        );
    }

    public function saveCustomizeMapID(): bool {
        return $this->updateTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            array(
                self::DB_CUSTOMIZE_ROOM_SAVE_MAP => json_encode($this->customizeMapID, true),
            )
        );
    }

    public function saveLicenceNum(): bool {
        return $this->updateTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            array(
                self::DB_LICENCE_NUM => $this->licenceNum,
            )
        );
    }

    public function saveLicenceDate(): bool {
        return $this->updateTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            array(
                self::DB_LICENCE_DATE => $this->licenceDate,
            )
        );
    }

    public function saveClubExitTime(): bool {
        return $this->updateTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            array(
                self::DB_ClUB_EXIT_TIME => $this->clubExitTime,
            )
        );
    }

    public function saveAccountData(array $data): bool
    {
        return $this->updateTitle(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            $data
        );
    }

    public function increaseAccountData($attr, int $score): bool
    {
        //判断已存储的值是否是负数
        if (!$this->searchTerm($data,
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            $attr,)){
            return false;
        }
        if ($data[$attr] == 0) {
            $num = 0;
        }else{
            $num = $data[$attr];
        }

        if ($num + $score <= 0 ) {
            $score = -$num;
        }

        if ($score == 0){
            return false;
        }

        return $this->autoAddTerm(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            $attr,
            $score,
            $ret
        );
    }

    public function increaseAccountDataValue(string $attr, int $score, &$ret): bool
    {
        return $this->autoAddTerm(
            DBTableDefine::TABLE_ACCOUNT,
            $this->playerId,
            0,
            $attr,
            $score,
            $ret
        );
    }

    public function searchData():bool {
        $account = [];
        if(!$this->searchTitle(DBTableDefine::TABLE_ACCOUNT, $this->playerId, 0, $account)) {
            return false;
        }
        $this->setRoleID((int)$account[AccountData::DB_RoleId]);
        $this->nickName = $account[AccountData::DB_NICK_NAME];
        $this->defaultCar = $account[AccountData::DB_DEFAULT_CAR];
        $this->defaultCarTpl = $account[AccountData::DB_DEFAULT_CAT_TPL];
        $this->head = $account[AccountData::DB_HEAD];
        $this->gender = $account[AccountData::DB_GENDER];
        return true;
    }

    public function setRoleID(int $roleID) {
        $this->roleId = $roleID;
    }
}
