<?php

/**
 * 测试消息控制器
 * Created On 2021/11/1
 * @author yuanb yuanbo0x@gmail.com
 */

namespace Game\Controller;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Protobuf\PacketId;
use Game\Protobuf\TestRecv;
use Game\Protobuf\TestSend;

/**
 * 测试消息控制器
 */
class Test extends ControllerBase
{
    /**
     * 构造函数，初始化对应消息
     */
    public function __construct()
    {
        $this->message = new TestSend();
    }

    /**
     * 解析消息后，执行逻辑
     * @return int
     */
    public function run(): int
    {
        $a = $this->message->getA();
        $b = $this->message->getB();
        $c = $this->message->getC();
        $d = $this->message->getD();
        $e = $this->message->getE();

        $packet = new TestRecv();
        $packet->setRA(123);
        $packet->setRB(18.36);
        $packet->setRC(1823456861364);
        $packet->setRD(true);
        $packet->setRE('Merry Christmas');
        SendMessage::getInstance()->sendClient(PacketId::Test_Recv, $packet);
        return ErrorDefine::SUCCESS;
    }
}
