<?php

/**
 * 获取技巧教学关卡信息
 */

namespace Game\Controller\TeachingSkill;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ModelTypeDefine;
use Game\Logic\PVE\TeachingSkillLogic;
use Game\Model\PVE\PveModel;
use Game\Protobuf\CGTeachingSkillChapter;
use Game\Protobuf\GCTeachingSkillChapter;
use Game\Protobuf\PacketId;

class CG_TeachingSkillChapter extends ControllerBase
{
    use TeachingSkillLogic;

    private GCTeachingSkillChapter $sendMessage;

    public function __construct()
    {
        $this->message = new CGTeachingSkillChapter();
    }

    public function run(): int
    {
        $chapterId = $this->message->getTeachingSkillLv();
        /**
         * @var PveModel $pveModel
         */
        $pveModel = ModelManager::getInstance()->getModel(ModelTypeDefine::PVE);
        $lv = $pveModel->getTeachingSkillLv();
        //检查是否解锁
        if ($chapterId > $lv + 1) {
            //未解锁
            $this->sendMessage->setLevel(array());
            SendMessage::getInstance()->sendClient(PacketId::GC_TeachingSkillChapter, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }
        if ($chapterId == 0) {
            //返回C级关卡
            $chapterId = 1;
        }
        $this->sendTeachingSkillChapterLevelMessage($chapterId);
        return ErrorDefine::SUCCESS;
    }
}
