<?php

/**
 * 战令 索要/赠送 查找好友
 */

namespace Game\Controller\Task;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\ConstTemplate\TemplateConst;
use Game\Constant\ModelTypeDefine;
use Game\Constant\TemplateDefine;
use Game\Data\WarTokenData;
use Game\Model\Task\WarTokenModel;
use Game\Protobuf\CGZLFindFriends;
use Game\Protobuf\FriendRole;
use Game\Protobuf\GCZLfindFriends;
use Game\Protobuf\PacketId;
use Game\Logic\Friend\FriendLogic;

class ZLFindFriends extends ControllerBase
{
    use FriendLogic;

    private GCZLfindFriends $sendMessage;

    public function __construct()
    {
        $this->message = new CGZLFindFriends();
        $this->sendMessage = new GCZLfindFriends();
    }

    public function run(): int
    {
        $option = $this->message->getOption();
        // todo: 后续好友模块提供查询所有好友接口 再替换
//        $page = $this->getAllFriendsPage();
        $page = 1;
        [$info, $infoExt] = $this->getMineList($page);

        if(empty($info)) {
            $this->sendZLFindFriendsMsg(ClientErrorCode::CLIENT_SUCCESS, $option, []);
            return ErrorDefine::SUCCESS;
        }
        if($option == WarTokenData::ZL_DEMAND) {
            $this->handleFilterDemandFriends($info);
        } else if( $option == WarTokenData::ZL_GIVE) {
            $this->handleFilterGiveFriends($info);
        }

        $this->sendZLFindFriendsMsg(ClientErrorCode::CLIENT_SUCCESS, $option, $info);
        return ErrorDefine::SUCCESS;
    }
    private function getAllFriendsPage() : int {
        $numMax = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_Friend_Number,
            TemplateConst::ConstNum);
        $pageNumMax = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_Friend_List_Number,
            TemplateConst::ConstNum);
        return intdiv($numMax, $pageNumMax);
    }

    private function sendZLFindFriendsMsg(int $code, int $option, array $info) {
        $this->sendMessage->setCode($code);
        $this->sendMessage->setOption($option);
        $this->sendMessage->setInfo($info);
        SendMessage::getInstance()->sendClient(PacketId::GC_ZLFindFriends, $this->sendMessage);
    }

    // 筛选符合要求的好友(索要)
    private function handleFilterDemandFriends(array &$players): void
    {
        $level = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_ZL_Level_Limit,
            TemplateConst::ConstNum);
        $intimacy = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_ZL_Intimacy_Limit,
            TemplateConst::ConstNum);
        /**
         * @var FriendRole $player
         */
        foreach($players as $index => $player) {
            if($player->getLevel() < $level) {
                unset($players[$index]);
                continue;
            }
            if($player->getIntimacy() < $intimacy) {
                unset($players[$index]);
                continue;
            }
        }
    }

    // 筛选符合要求的好友(赠送)
    private function handleFilterGiveFriends(array &$players): void
    {
        $level = $this->getTerm(TemplateDefine::TYPE_CONST,
            TemplateConst::Const_ZL_Level_Limit,
            TemplateConst::ConstNum);
        /**
         * @var FriendRole $player
         */
        foreach($players as $index => $player) {
            if($player->getLevel() < $level) {
                unset($players[$index]);
                continue;
            }
            // 好友是否开通了战令
            /**
             * @var WarTokenModel $warTokenModel
             */
            $warTokenModel = ModelManager::getInstance()->getModel(ModelTypeDefine::WAR_TOKEN);
            $warTokenModel->setPlayerId($player->getPlayerId());
            $warTokenData =  $warTokenModel->getWarTokenData();
            if($warTokenData->expertFlag != $warTokenData::EXPERT_FLAG_DEFAULT) {
                unset($players[$index]);
            }
        }
    }
}
