<?php

/**
 * 领取战令奖励
 */

namespace Game\Controller\Task;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Constant\GameConstantDefine;
use Game\Logic\WarTokenLogic;
use Game\Protobuf\CGZLReward;
use Game\Protobuf\GCZLRewardResult;
use Game\Protobuf\PacketId;

class CG_ZLReward extends ControllerBase
{
    use WarTokenLogic;

    private GCZLRewardResult $sendMessage;

    //领取方式 0 普通 1领取初级 2领取高级 3一键领取
    public const OPTION_SINGLE_PRIMARY = 0;
    public const OPTION_SINGLE_EXPERT = 1;
    public const OPTION_SINGLE_ELITE = 2;
    public const OPTION_ONE_KEY = 3;

    public function __construct()
    {
        $this->message = new CGZLReward();
        $this->sendMessage = new GCZLRewardResult();
    }

    public function run(): int
    {
        //检查赛季状态
        if ($this->getSeasonStatus() == GameConstantDefine::SEASON_STATUS_CLOSE) {
            return $this->sendMessage(ClientErrorCode::SEASON_CLOSE);
        }
        $option = $this->message->getOption();
        switch ($option) {
            case self::OPTION_SINGLE_EXPERT:
            case self::OPTION_SINGLE_ELITE:
            case self::OPTION_SINGLE_PRIMARY:
                //校验
                $code = $this->checkGetWarTokenReward($this->message->getId(), $option);
                if ($code != ClientErrorCode::CLIENT_SUCCESS) {
                    return $this->sendMessage($code);
                }
                //领奖
                $this->getWarTokenReward($this->message->getId(), $option);
                return $this->sendMessage(ClientErrorCode::CLIENT_SUCCESS);
            case self::OPTION_ONE_KEY:
                $this->oneKeyGetWarTokenReward();
                return $this->sendMessage(ClientErrorCode::CLIENT_SUCCESS);
        }
        return ErrorDefine::SUCCESS;
    }

    private function sendMessage(int $code): int
    {
        $this->sendMessage->setCode($code);
        SendMessage::getInstance()->sendClient(PacketId::GC_ZLRewardResult, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
