<?php

/**
 * 获取任务
 */

namespace Game\Controller\Task;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ConstTemplate\TemplateTask;
use Game\Data\TaskData;
use Game\Logic\Task\TaskLogic;
use Game\Protobuf\CGTaskSearch;
use Game\Protobuf\GCTaskList;
use Game\Protobuf\PacketId;
use Game\Protobuf\Task;

class CG_TaskSearch extends ControllerBase
{
    use TaskLogic;

    private GCTaskList $sendMessage;

    public function __construct()
    {
        $this->message = new CGTaskSearch();
        $this->sendMessage = new GCTaskList();
    }

    public function run(): int
    {
        $taskType = $this->message->getType();
        $taskList = array();
        $completeTaskList = array();
        switch ($taskType) {
            case TemplateTask::TASK_TYPE_DAILY:
                [$taskList, $completeTaskList] = $this->getDailyTask();
                break;
            case TemplateTask::TASK_TYPE_WELFARE_WEEK:
                [$taskList, $completeTaskList] = $this->getWelfareWeekTask();
                break;
            case TemplateTask::TASK_TYPE_MAIN:
                [$taskList, $completeTaskList] = $this->getMainTask();
                break;
            case TemplateTask::TASK_TYPE_BRANCH:
                //检查是否有车
                if ($this->checkHasCar($this->message->getCarTplId())) {
                    [$taskList, $completeTaskList] = $this->getBranchTask($this->message->getCarTplId());
                }
                break;
            case TemplateTask::TASK_TYPE_SEASON_WEEK:
            case TemplateTask::TASK_TYPE_SEASON:
                //未开启的周 返回空
                [$taskList, $completeTaskList] = $this->getSeasonTask($this->message->getWeek());
                break;
            case TemplateTask::TASK_TYPE_DAILY_CHALLENGE:
                [$taskList, $completeTaskList] = $this->getDailyChallengeTask();
                break;
        }

        //返回消息
        $taskMessage = array();
        /**
         * @var TaskData $taskData
         */
        foreach ($taskList as $taskData) {
            $task = new Task();
            $task->setTaskId($taskData->taskId);
            $task->setStatus($taskData->status);
            $task->setSchedule($taskData->schedule);
            array_push($taskMessage, $task);
        }
        $this->sendMessage->setTaskList($taskMessage);
        $this->sendMessage->setCompleteTaskList($completeTaskList);
        SendMessage::getInstance()->sendClient(PacketId::GC_TaskList, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
