<?php

/**
 * 刷新日常挑战任务
 */

namespace Game\Controller\Task;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\Task\DailyTaskLogic;
use Game\Protobuf\CGRefreshDailyChallengeTask;
use Game\Protobuf\GCRefreshDailyChallengeTask;
use Game\Protobuf\PacketId;
use Game\Protobuf\Task;

class CG_RefreshDailyChallengeTask extends ControllerBase
{
    use DailyTaskLogic;

    private GCRefreshDailyChallengeTask $sendMessage;

    public function __construct()
    {
        $this->message = new CGRefreshDailyChallengeTask();
        $this->sendMessage = new GCRefreshDailyChallengeTask();
    }

    public function run(): int
    {
        [$code, $refreshNum, $taskData] = $this->refreshDailyChallengeTask($this->message->getTaskId());
        $this->sendMessage->setCode($code);
        if ($code == ClientErrorCode::CLIENT_SUCCESS) {
            $this->sendMessage->setRefreshNum($refreshNum);
            $this->sendMessage->setDelTaskId($this->message->getTaskId());
            $task = new Task();
            $task->setTaskId($taskData->taskId);
            $task->setStatus($taskData->status);
            $task->setSchedule($taskData->schedule);
            $this->sendMessage->setNewTask($task);
        }
        SendMessage::getInstance()->sendClient(PacketId::GC_RefreshDailyChallengeTask, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
