<?php

/**
 * 获取好友亲密关系任务
 */

namespace Game\Controller\Task;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Data\TaskData;
use Game\Logic\Task\FriendIntimacyRewardLogic;
use Game\Logic\Task\TaskLogic;
use Game\Protobuf\CGFriendIntimacyTask;
use Game\Protobuf\GCFriendIntimacyTask;
use Game\Protobuf\PacketId;
use Game\Protobuf\Task;

class CG_FriendIntimacyTask extends ControllerBase
{
    use FriendIntimacyRewardLogic;
    use TaskLogic;

    private GCFriendIntimacyTask $sendMessage;

    public function __construct()
    {
        $this->message = new CGFriendIntimacyTask();
        $this->sendMessage = new GCFriendIntimacyTask();
    }

    public function run(): int
    {
        //检查是否开启
        if ($this->checkFriendIntimacyRewardIsOpen()) {
            $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
            $data = $this->getFriendIntimacyRewardData();
            $this->sendMessage->setScore($data->friendIntimacyRewardScore);
            $this->sendMessage->setSchedule(json_decode($data->friendIntimacyRewardSchedule, true));
            [$taskList, $completeTaskList] = $this->getFriendIntimacyRewardTask();
            /**
             * @var TaskData $taskData
             */
            $taskMessage = array();
            foreach ($taskList as $taskData) {
                $task = new Task();
                $task->setTaskId($taskData->taskId);
                $task->setStatus($taskData->status);
                $task->setSchedule($taskData->schedule);
                $taskMessage[] = $task;
            }
            $this->sendMessage->setCompleteTaskList($completeTaskList);
            $this->sendMessage->setTaskList($taskMessage);
        } else {
            $this->sendMessage->setCode(ClientErrorCode::FRIEND_INTIMACY_REWARD_NOT_OPEN);
        }
        SendMessage::getInstance()->sendClient(PacketId::GC_FriendIntimacyTask, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
