<?php

/**
 * 领取好友亲密关系奖励
 */

namespace Game\Controller\Task;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Task\FriendIntimacyRewardLogic;
use Game\Protobuf\CGFriendIntimacyReward;
use Game\Protobuf\GCFriendIntimacyReward;
use Game\Protobuf\PacketId;

class CG_FriendIntimacyReward extends ControllerBase
{
    use FriendIntimacyRewardLogic;

    private GCFriendIntimacyReward $sendMessage;

    public function __construct()
    {
        $this->message = new CGFriendIntimacyReward();
        $this->sendMessage = new GCFriendIntimacyReward();
    }

    public function run(): int
    {
        $schedule = array();
        $this->sendMessage->setCode(
            $this->getFriendIntimacyReward(
                $this->message->getRewardId(),
                $schedule
            )
        );
        $this->sendMessage->setSchedule($schedule);
        $this->sendMessage->setRewardId(
            $this->message->getRewardId()
        );
        SendMessage::getInstance()->sendClient(PacketId::GC_FriendIntimacyReward, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
