<?php

/**
 * 购买战令等级
 */

namespace Game\Controller\Task;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\WarTokenLogic;
use Game\Protobuf\CGBuyZLLevel;
use Game\Protobuf\GCBuyZLLevelResult;
use Game\Protobuf\PacketId;

class CG_BuyZLLevel extends ControllerBase
{
    use WarTokenLogic;

    private GCBuyZLLevelResult $sendMessage;

    public function __construct()
    {
        $this->message = new CGBuyZLLevel();
        $this->sendMessage = new GCBuyZLLevelResult();
    }

    public function run(): int
    {
        $level = $this->message->getLevel();
        //购买校验
        $code = $this->checkBuyWarTokenLevel($level);
        if ($code != ClientErrorCode::CLIENT_SUCCESS) {
            $this->sendMessage->setCode($code);
            SendMessage::getInstance()->sendClient(PacketId::GC_BuyZLLevelResult, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }

        //购买
        $this->buyWarTokenLevel($level);
        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        SendMessage::getInstance()->sendClient(PacketId::GC_BuyZLLevelResult, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
