<?php

/**
 * 开通战令高级
 */

namespace Game\Controller\Task;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Constant\ClientErrorCode;
use Game\Logic\WarTokenLogic;
use Game\Protobuf\CGBuyZLExpert;
use Game\Protobuf\GCBuyZLExpertResult;
use Game\Protobuf\PacketId;

class CG_BuyZLExpert extends ControllerBase
{
    use WarTokenLogic;

    private GCBuyZLExpertResult $sendMessage;

    public function __construct()
    {
        $this->message = new CGBuyZLExpert();
        $this->sendMessage = new GCBuyZLExpertResult();
    }

    public function run(): int
    {
        $level = $this->message->getID();
        //开通校验
        $code = $this->checkOpenExpertFlag($level);
        if ($code != ClientErrorCode::CLIENT_SUCCESS) {
            $this->sendMessage->setCode($code);
            SendMessage::getInstance()->sendClient(PacketId::GC_BuyZLExpertResult, $this->sendMessage);
            return ErrorDefine::SUCCESS;
        }

        // 提升等级
        $this->addZlLevel($level);

        // 开通对应战令
        $this->openExpertFlag($level);

        $this->sendMessage->setCode(ClientErrorCode::CLIENT_SUCCESS);
        SendMessage::getInstance()->sendClient(PacketId::GC_BuyZLExpertResult, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
