<?php

/**
 * 比赛统计信息
 */

namespace Game\Controller\Statistics;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\SeasonStatisticsLogic;
use Game\Protobuf\CGStatisticsInfo;
use Game\Protobuf\PacketId;

class CG_StatisticsInfo extends ControllerBase
{
    use SeasonStatisticsLogic;

    public function __construct()
    {
        $this->message = new CGStatisticsInfo();
    }

    public function run(): int
    {
        $sendMessage = $this->getSeasonStatistics($this->message->getMode(), $this->message->getSeason());
        SendMessage::getInstance()->sendClient(PacketId::GC_StatisticsInfo, $sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
