<?php

/**
 * 获取比赛详情
 */

namespace Game\Controller\Statistics;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\RecordLogic;
use Game\Protobuf\CGMatchRecordDetail;
use Game\Protobuf\PacketId;

class CG_MatchRecordDetail extends ControllerBase
{
    use RecordLogic;

    public function __construct()
    {
        $this->message = new CGMatchRecordDetail();
    }

    public function run(): int
    {
        SendMessage::getInstance()->sendClient(
            PacketId::GC_MatchRecordDetail,
            $this->getRecordDetail($this->message->getId())
        );
        return ErrorDefine::SUCCESS;
    }
}
