<?php

/**
 * 获取比赛记录
 */

namespace Game\Controller\Statistics;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\RecordLogic;
use Game\Protobuf\CGMatchRecord;
use Game\Protobuf\GCMatchRecord;
use Game\Protobuf\PacketId;

class CG_MatchRecord extends ControllerBase
{
    use RecordLogic;

    private GCMatchRecord $sendMessage;

    public function __construct()
    {
        $this->message = new CGMatchRecord();
        $this->sendMessage = new GCMatchRecord();
    }

    public function run(): int
    {
        $this->sendMessage->setRecord($this->getRecordByPage($this->message->getPage()));
        $this->sendMessage->setCollectionNum($this->getCollectionNum());
        SendMessage::getInstance()->sendClient(PacketId::GC_MatchRecord, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
