<?php

/**
 * 获取收藏的比赛记录
 */

namespace Game\Controller\Statistics;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\RecordLogic;
use Game\Protobuf\CGMatchCollectionRecord;
use Game\Protobuf\GCMatchCollectionRecord;
use Game\Protobuf\PacketId;

class CG_MatchCollectionRecord extends ControllerBase
{
    use RecordLogic;

    private GCMatchCollectionRecord $sendMessage;

    public function __construct()
    {
        $this->message = new CGMatchCollectionRecord();
        $this->sendMessage = new GCMatchCollectionRecord();
    }

    public function run(): int
    {
        $this->sendMessage->setRecord($this->getCollectionRecordByPage($this->message->getPage()));
        SendMessage::getInstance()->sendClient(PacketId::GC_MatchCollectionRecord, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
