<?php

/**
 * 添加/取消收藏
 */

namespace Game\Controller\Statistics;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\RecordLogic;
use Game\Protobuf\CGCollectionOption;
use Game\Protobuf\GCCollectionOption;
use Game\Protobuf\PacketId;

class CG_CollectionOption extends ControllerBase
{
    use RecordLogic;

    private GCCollectionOption $sendMessage;

    private const OPTION_ADD = 1;   //添加收藏
    private const OPTION_REMOVE = 2;   //取消收藏

    public function __construct()
    {
        $this->message = new CGCollectionOption();
        $this->sendMessage = new GCCollectionOption();
    }

    public function run(): int
    {
        if ($this->message->getOption() == self::OPTION_ADD) {
            $code = $this->addCollection($this->message->getId());
        } else {
            $code = $this->removeCollection($this->message->getId());
        }
        $this->sendMessage->setCode($code);
        $this->sendMessage->setCollectionNum($this->getCollectionNum());
        SendMessage::getInstance()->sendClient(PacketId::GC_CollectionOption, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
