<?php

/**
 * 赛车统计信息
 */

namespace Game\Controller\Statistics;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Car\CarStatisticsLogic;
use Game\Protobuf\CGCarStatisticsInfo;
use Game\Protobuf\GCCarStatisticsInfo;
use Game\Protobuf\PacketId;

class CG_CarStatisticsInfo extends ControllerBase
{
    use CarStatisticsLogic;

    private GCCarStatisticsInfo $sendMessage;

    public function __construct()
    {
        $this->message = new CGCarStatisticsInfo();
        $this->sendMessage = new GCCarStatisticsInfo();
    }

    public function run(): int
    {
        $protoArray = array();
        if ($this->message->getCarUid() == 0) {
            //获取全部赛车统计信息
            $this->getAllCarCarStatisticsInfo($protoArray);
        } else {
            $this->getSingleCarCarStatisticsInfo($this->message->getCarUid(), $protoArray);
        }
        $this->sendMessage->setInfo($protoArray);
        SendMessage::getInstance()->sendClient(PacketId::GC_CarStatisticsInfo, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
