<?php

/**
 * 获取战令商城道具
 */

namespace Game\Controller\Shop\ShopZL;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ModelTypeDefine;
use Game\Model\Shop\ShopZLModel;
use Game\Protobuf\CGShopZL;
use Game\Protobuf\GCShopZL;
use Game\Protobuf\PacketId;

class ShopZL extends ControllerBase
{
    private GCShopZL $sendMessage;

    public function __construct()
    {
        $this->message = new CGShopZL();
        $this->sendMessage = new GCShopZL();
    }

    public function run(): int
    {
        /**
         * @var ShopZLModel $shopModel
         */
        $shopModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SHOP_ZL);
        $shopModel->addSendShopItem($shopModel->getShopItem());
        $this->sendMessage->setItem($shopModel->getSendShopItem());
        SendMessage::getInstance()->sendClient(PacketId::GC_ShopZL, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
