<?php

/**
 * 购买战令商城道具
 */

namespace Game\Controller\Shop\ShopZL;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Shop\ShopZLLogic;
use Game\Protobuf\CGBuyShopZL;
use Game\Protobuf\GCBuyShopZL;
use Game\Protobuf\PacketId;

class BuyShopZL extends ControllerBase
{
    use ShopZLLogic;

    private GCBuyShopZL $sendMessage;

    public function __construct()
    {
        $this->message = new CGBuyShopZL();
        $this->sendMessage = new GCBuyShopZL();
    }

    public function run(): int
    {
        $this->sendMessage->setCode(
            $this->buyShopZLItem(
                $this->message->getId(),
                $this->message->getNum()
            )
        );
        $this->sendMessage->setItem($this->getSendShopItem());
        SendMessage::getInstance()->sendClient(PacketId::GC_BuyShopZL, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
