<?php

/**
 * 获取赛季商城道具
 */

namespace Game\Controller\Shop\ShopSeason;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ModelTypeDefine;
use Game\Model\Shop\ShopSeasonModel;
use Game\Protobuf\CGShopSeason;
use Game\Protobuf\GCShopSeason;
use Game\Protobuf\PacketId;

class CG_ShopSeason extends ControllerBase
{
    private GCShopSeason $sendMessage;

    public function __construct()
    {
        $this->message = new CGShopSeason();
        $this->sendMessage = new GCShopSeason();
    }

    public function run(): int
    {
        /**
         * @var ShopSeasonModel $shopSeasonModel
         */
        $shopSeasonModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SHOP_SEASON);
        $shopSeasonModel->addSendShopItem($shopSeasonModel->getShopItem());
        $this->sendMessage->setItem($shopSeasonModel->getSendShopItem());
        SendMessage::getInstance()->sendClient(PacketId::GC_ShopSeason, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
