<?php

/**
 * 购买赛季商城道具
 */

namespace Game\Controller\Shop\ShopSeason;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Shop\ShopSeasonLogic;
use Game\Protobuf\CGBuyShopSeason;
use Game\Protobuf\GCBuyShopSeason;
use Game\Protobuf\PacketId;

class CG_BuyShopSeason extends ControllerBase
{
    use ShopSeasonLogic;

    private GCBuyShopSeason $sendMessage;

    public function __construct()
    {
        $this->message = new CGBuyShopSeason();
        $this->sendMessage = new GCBuyShopSeason();
    }

    public function run(): int
    {
        $this->sendMessage->setCode(
            $this->buyShopSeasonItem(
                $this->message->getId(),
                $this->message->getNum()
            )
        );
        $this->sendMessage->setItem($this->getSendShopItem());
        SendMessage::getInstance()->sendClient(PacketId::GC_BuyShopSeason, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
