<?php

/**
 * 购买推荐商城道具
 */

namespace Game\Controller\Shop\ShopRecommend;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Shop\ShopRecommendLogic;
use Game\Protobuf\CGBuyShopRecommend;
use Game\Protobuf\GCBuyShopRecommend;
use Game\Protobuf\PacketId;

class CG_BuyShopRecommend extends ControllerBase
{
    use ShopRecommendLogic;

    private GCBuyShopRecommend $sendMessage;

    public function __construct()
    {
        $this->message = new CGBuyShopRecommend();
        $this->sendMessage = new GCBuyShopRecommend();
    }

    public function run(): int
    {
        $this->sendMessage->setCode(
            $this->buyShopRecommend(
                $this->message->getId(),
                $this->message->getNum()
            )
        );
        $this->sendMessage->setId($this->message->getId());
        $this->sendMessage->setNum($this->message->getNum());
        SendMessage::getInstance()->sendClient(PacketId::GC_BuyShopRecommend, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
