<?php

/**
 * 获取道具商城道具
 */

namespace Game\Controller\Shop\ShopItem;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\MVC\ModelManager;
use Framework\Network\SendMessage;
use Game\Constant\ModelTypeDefine;
use Game\Model\Shop\ShopItemModel;
use Game\Protobuf\CGShopItem;
use Game\Protobuf\GCShopItem;
use Game\Protobuf\PacketId;

class CG_ShopItem extends ControllerBase
{
    private GCShopItem $sendMessage;

    public function __construct()
    {
        $this->message = new CGShopItem();
        $this->sendMessage = new GCShopItem();
    }

    public function run(): int
    {
        /**
         * @var ShopItemModel $shopItemModel
         */
        $shopItemModel = ModelManager::getInstance()->getModel(ModelTypeDefine::SHOP_ITEM);
        $shopItemModel->addSendShopItem($shopItemModel->getShopItem());
        $this->sendMessage->setItem($shopItemModel->getSendShopItem());
        SendMessage::getInstance()->sendClient(PacketId::GC_ShopItem, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
