<?php

/**
 * 购买道具商城道具
 */

namespace Game\Controller\Shop\ShopItem;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Shop\ShopItemLogic;
use Game\Protobuf\CGBuyShopItem;
use Game\Protobuf\GCBuyShopItem;
use Game\Protobuf\PacketId;

class CG_BuyShopItem extends ControllerBase
{
    use ShopItemLogic;

    private GCBuyShopItem $sendMessage;

    public function __construct()
    {
        $this->message = new CGBuyShopItem();
        $this->sendMessage = new GCBuyShopItem();
    }

    public function run(): int
    {
        $this->sendMessage->setCode($this->buyShopItem($this->message->getId(), $this->message->getNum()));
        $this->sendMessage->setItem($this->getSendShopItem());
        SendMessage::getInstance()->sendClient(PacketId::GC_BuyShopItem, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
