<?php

/**
 * 购买服装商城服装
 */

namespace Game\Controller\Shop\ShopClothing;

use Framework\Define\ErrorDefine;
use Framework\MVC\ControllerBase;
use Framework\Network\SendMessage;
use Game\Logic\Shop\ShopClothingLogic;
use Game\Protobuf\CGBuyShopClothing;
use Game\Protobuf\GCBuyShopClothing;
use Game\Protobuf\PacketId;

class CG_BuyShopClothing extends ControllerBase
{
    use ShopClothingLogic;

    private GCBuyShopClothing $sendMessage;

    public function __construct()
    {
        $this->message = new CGBuyShopClothing();
        $this->sendMessage = new GCBuyShopClothing();
    }

    public function run(): int
    {
        $this->sendMessage->setCode($this->buyShopClothing($this->message->getIds(), $this->message->getCouponId(), $this->playerId));
        SendMessage::getInstance()->sendClient(PacketId::GC_BuyShopClothing, $this->sendMessage);
        return ErrorDefine::SUCCESS;
    }
}
